/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class StorageServicePropertiesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<StorageService.StorageServiceProperties> {
    private String description;
    private String affinityGroup;
    private String location;
    private String label;
    private StorageService.Status status;
    private final List<URL> endpoints = Lists.newArrayList();
    private boolean inEndpoints;
    private String geoPrimaryRegion;
    private StorageService.RegionStatus statusOfPrimary;
    private Date lastGeoFailoverTime;
    private String geoSecondaryRegion;
    private StorageService.RegionStatus statusOfSecondary;
    private Date creationTime;
    private final List<String> customDomains = Lists.newArrayList();
    private final List<URL> secondaryEndpoints = Lists.newArrayList();
    private boolean inSecondaryEndpoints;
    private StorageService.AccountType accountType;
    private final DateService dateService;
    private final StringBuilder currentText = new StringBuilder();

    public StorageServicePropertiesHandler(DateService dateService) {
        this.dateService = dateService;
    }

    public StorageService.StorageServiceProperties getResult() {
        StorageService.StorageServiceProperties result = StorageService.StorageServiceProperties.create(this.description, this.affinityGroup, this.location, this.label, this.status, this.endpoints, this.geoPrimaryRegion, this.statusOfPrimary, this.lastGeoFailoverTime, this.geoSecondaryRegion, this.statusOfSecondary, this.creationTime, this.customDomains, this.secondaryEndpoints, this.accountType);
        this.label = null;
        this.location = null;
        this.affinityGroup = null;
        this.description = null;
        this.status = null;
        this.endpoints.clear();
        this.geoPrimaryRegion = null;
        this.statusOfPrimary = null;
        this.lastGeoFailoverTime = null;
        this.geoSecondaryRegion = null;
        this.statusOfSecondary = null;
        this.creationTime = null;
        this.customDomains.clear();
        this.secondaryEndpoints.clear();
        this.accountType = null;
        return result;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("Endpoints".equals(qName)) {
            this.inEndpoints = true;
        } else if ("SecondaryEndpoints".equals(qName)) {
            this.inSecondaryEndpoints = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if ("Description".equals(qName)) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("AffinityGroup".equals(qName)) {
            this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Location".equals(qName)) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Label".equals(qName)) {
            this.label = new String(BaseEncoding.base64().decode((CharSequence)SaxUtils.currentOrNull((StringBuilder)this.currentText)), Charsets.UTF_8);
        } else if ("Status".equals(qName)) {
            this.status = StorageService.Status.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if ("Endpoints".equals(qName)) {
            this.inEndpoints = false;
        } else if ("SecondaryEndpoints".equals(qName)) {
            this.inSecondaryEndpoints = false;
        } else if ("Endpoint".equals(qName)) {
            urlText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            try {
                if (this.inEndpoints) {
                    this.endpoints.add(new URL(urlText));
                }
                if (!this.inSecondaryEndpoints) ** GOTO lbl63
                this.secondaryEndpoints.add(new URL(urlText));
            }
            catch (MalformedURLException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else if ("GeoPrimaryRegion".equals(qName)) {
            this.geoPrimaryRegion = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("StatusOfPrimary".equals(qName)) {
            this.statusOfPrimary = StorageService.RegionStatus.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if ("LastGeoFailoverTime".equals(qName)) {
            this.lastGeoFailoverTime = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if ("GeoSecondaryRegion".equals(qName)) {
            this.geoSecondaryRegion = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("StatusOfSecondary".equals(qName)) {
            text = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (text != null) {
                this.statusOfSecondary = StorageService.RegionStatus.fromString(text);
            }
        } else if ("CreationTime".equals(qName)) {
            this.creationTime = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if ("Name".equals(qName)) {
            text = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (text != null) {
                this.customDomains.add(text);
            }
        } else if ("AccountType".equals(qName)) {
            this.accountType = StorageService.AccountType.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
lbl63:
        // 20 sources

        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

