/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.ReservedIPAddress;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ReservedIPAddressHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ReservedIPAddress> {
    private String name;
    private String address;
    private String id;
    private String label;
    private ReservedIPAddress.State state;
    private Boolean inUse;
    private String serviceName;
    private String deploymentName;
    private String location;
    private final StringBuilder currentText = new StringBuilder();

    public ReservedIPAddress getResult() {
        ReservedIPAddress result = ReservedIPAddress.create(this.name, this.address, this.id, this.label, this.state, this.inUse, this.serviceName, this.deploymentName, this.location);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.location = null;
        this.deploymentName = null;
        this.serviceName = null;
        this.label = null;
        this.id = null;
        this.address = null;
        this.name = null;
        this.state = null;
        this.inUse = null;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) {
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Address")) {
            this.address = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Id")) {
            this.id = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("State")) {
            this.state = ReservedIPAddress.State.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("InUse")) {
            String use = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.inUse = use == null ? null : Boolean.valueOf(use);
        } else if (qName.equals("ServiceName")) {
            this.serviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DeploymentName")) {
            this.deploymentName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

