/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import java.net.URI;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public class OSVirtualHardDiskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Role.OSVirtualHardDisk> {
    private String hostCaching;
    private String diskName;
    private URI mediaLink;
    private String sourceImageName;
    private OSImage.Type os;
    private Integer lun;
    private Integer logicalDiskSizeInGB;
    private final StringBuilder currentText = new StringBuilder();

    public Role.OSVirtualHardDisk getResult() {
        return Role.OSVirtualHardDisk.create(this.hostCaching, this.diskName, this.lun, this.logicalDiskSizeInGB, this.mediaLink, this.sourceImageName, this.os);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        String osText;
        if (qName.equals("HostCaching")) {
            this.hostCaching = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DiskName")) {
            this.diskName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("MediaLink")) {
            String link = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (link != null) {
                this.mediaLink = URI.create(link);
            }
        } else if (qName.equals("SourceImageName")) {
            this.sourceImageName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("OS") && (osText = SaxUtils.currentOrNull((StringBuilder)this.currentText)) != null) {
            this.os = OSImage.Type.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText).toUpperCase());
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

