/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.inject.Inject;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.azurecompute.xml.VirtualNetworkConfigurationHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public class NetworkConfigurationHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NetworkConfiguration> {
    private NetworkConfiguration.VirtualNetworkConfiguration virtualNetworkConfiguration;
    private boolean inVirtualNetworkConfiguration;
    private final VirtualNetworkConfigurationHandler virtualNetworkConfigurationHandler;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    NetworkConfigurationHandler(VirtualNetworkConfigurationHandler virtualNetworkConfigurationHandler) {
        this.virtualNetworkConfigurationHandler = virtualNetworkConfigurationHandler;
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("VirtualNetworkConfiguration")) {
            this.inVirtualNetworkConfiguration = true;
        }
        if (this.inVirtualNetworkConfiguration) {
            this.virtualNetworkConfigurationHandler.startElement(url, name, qName, attributes);
        }
    }

    public NetworkConfiguration getResult() {
        return NetworkConfiguration.create(this.virtualNetworkConfiguration);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("VirtualNetworkConfiguration")) {
            this.virtualNetworkConfiguration = this.virtualNetworkConfigurationHandler.getResult();
        } else if (this.inVirtualNetworkConfiguration) {
            this.virtualNetworkConfigurationHandler.endElement(ignoredUri, ignoredName, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inVirtualNetworkConfiguration) {
            this.virtualNetworkConfigurationHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

