/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.azurecompute.xml.VMImageHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ListVMImagesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<VMImage>> {
    private boolean inVMImage;
    private final VMImageHandler VMImageHandler;
    private final ImmutableList.Builder<VMImage> images = ImmutableList.builder();

    @Inject
    ListVMImagesHandler(VMImageHandler vmImageHandler) {
        this.VMImageHandler = vmImageHandler;
    }

    public List<VMImage> getResult() {
        return this.images.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("VMImage")) {
            this.inVMImage = true;
        }
        if (this.inVMImage) {
            this.VMImageHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("VMImage")) {
            this.inVMImage = false;
            this.images.add((Object)this.VMImageHandler.getResult());
        }
        if (this.inVMImage) {
            this.VMImageHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inVMImage) {
            this.VMImageHandler.characters(ch, start, length);
        }
    }
}

