/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.Location;
import org.jclouds.azurecompute.xml.LocationHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListLocationsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<Location>> {
    private boolean inLocation;
    private final LocationHandler locationHandler;
    private final ImmutableList.Builder<Location> locations = ImmutableList.builder();

    @Inject
    ListLocationsHandler(LocationHandler locationHandler) {
        this.locationHandler = locationHandler;
    }

    public List<Location> getResult() {
        return this.locations.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Location")) {
            this.inLocation = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Location")) {
            this.inLocation = false;
            this.locations.add((Object)this.locationHandler.getResult());
        } else if (this.inLocation) {
            this.locationHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inLocation) {
            this.locationHandler.characters(ch, start, length);
        }
    }
}

