/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import java.net.URI;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

final class DataVirtualHardDiskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<DataVirtualHardDisk> {
    private DataVirtualHardDisk.Caching hostCaching;
    private String diskName;
    private Integer lun;
    private Integer logicalDiskSizeInGB;
    private URI mediaLink;
    private String ioType;
    private final StringBuilder currentText = new StringBuilder();

    DataVirtualHardDiskHandler() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
    }

    public DataVirtualHardDisk getResult() {
        DataVirtualHardDisk result = DataVirtualHardDisk.create(this.hostCaching, this.diskName, this.lun, this.logicalDiskSizeInGB, this.mediaLink, this.ioType);
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("HostCaching")) {
            String hostCachingText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (hostCachingText != null) {
                this.hostCaching = DataVirtualHardDisk.Caching.fromString(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, hostCachingText));
            }
        } else if (qName.equals("DiskName") || qName.equals("Name")) {
            this.diskName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Lun")) {
            String lunText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (lunText != null) {
                this.lun = Integer.parseInt(lunText);
            }
        } else if (qName.equals("LogicalDiskSizeInGB")) {
            String gb = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (gb != null) {
                this.logicalDiskSizeInGB = Integer.parseInt(gb);
            }
        } else if (qName.equals("MediaLink")) {
            String link = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (link != null) {
                this.mediaLink = URI.create(link);
            }
        } else if (qName.equals("IOType")) {
            this.ioType = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

