/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.CloudService;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class CloudServiceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<CloudService> {
    private String name;
    private String location;
    private String affinityGroup;
    private String label;
    private String description;
    private CloudService.Status status;
    private Date created;
    private Date lastModified;
    private Map<String, String> extendedProperties = Maps.newLinkedHashMap();
    private boolean inHostedServiceProperties;
    private String propertyName;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateService;

    @Inject
    CloudServiceHandler(DateService dateService) {
        this.dateService = dateService;
    }

    public CloudService getResult() {
        CloudService result = CloudService.create(this.name, this.location, this.affinityGroup, this.label, this.description, this.status, this.created, this.lastModified, (Map<String, String>)ImmutableMap.copyOf(this.extendedProperties));
        this.resetState();
        return result;
    }

    private void resetState() {
        this.label = null;
        this.affinityGroup = null;
        this.location = null;
        this.description = null;
        this.name = null;
        this.status = null;
        this.lastModified = null;
        this.created = null;
        this.extendedProperties.clear();
        this.inHostedServiceProperties = false;
        this.propertyName = null;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) {
        if (qName.equals("HostedServiceProperties")) {
            this.inHostedServiceProperties = true;
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("HostedServiceProperties")) {
            this.inHostedServiceProperties = false;
        } else if (this.inHostedServiceProperties) {
            if (qName.equals("DateCreated")) {
                this.created = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("DateLastModified")) {
                this.lastModified = this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (qName.equals("Status")) {
                String statusText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
                this.status = CloudService.Status.fromString(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, statusText));
            } else if (qName.equals("Name")) {
                this.propertyName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Value")) {
                this.extendedProperties.put(this.propertyName, SaxUtils.currentOrNull((StringBuilder)this.currentText));
                this.propertyName = null;
            } else if (qName.equals("Description")) {
                this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Location")) {
                this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("AffinityGroup")) {
                this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("Label")) {
                this.label = new String(BaseEncoding.base64().decode((CharSequence)SaxUtils.currentOrNull((StringBuilder)this.currentText)), Charsets.UTF_8);
            }
        } else if (qName.equals("ServiceName")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

