/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.NetworkConfigurationToXML;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListVirtualNetworkSitesHandler;
import org.jclouds.azurecompute.xml.NetworkConfigurationHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/networking")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
public interface VirtualNetworkApi {
    @Named(value="GetVirtualNetworkConfiguration")
    @Path(value="/media")
    @GET
    @XMLResponseParser(value=NetworkConfigurationHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkConfiguration getNetworkConfiguration();

    @Named(value="ListVirtualNetworkSites")
    @Path(value="/virtualnetwork")
    @GET
    @XMLResponseParser(value=ListVirtualNetworkSitesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkConfiguration.VirtualNetworkSite> list();

    @Named(value="SetVirtualNetworkConfiguration")
    @Path(value="/media")
    @PUT
    @Produces(value={"text/plain"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String set(@BinderParam(value=NetworkConfigurationToXML.class) NetworkConfiguration var1);
}

