/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.ServiceCertificateParamsToXML;
import org.jclouds.azurecompute.domain.ServiceCertificate;
import org.jclouds.azurecompute.domain.ServiceCertificateParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListServiceCertificatesHandler;
import org.jclouds.azurecompute.xml.ServiceCertificateHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/hostedservices")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public interface ServiceCertificatesApi {
    @Named(value="ListServiceCertificates")
    @GET
    @Path(value="/{service}/certificates")
    @XMLResponseParser(value=ListServiceCertificatesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ServiceCertificate> list(@PathParam(value="service") String var1);

    @Named(value="GetServiceCertificate")
    @GET
    @Path(value="/{service}/certificates/{thumbprintAlgorithm}-{thumbprintInHexadecimal}")
    @XMLResponseParser(value=ServiceCertificateHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ServiceCertificate get(@PathParam(value="service") String var1, @PathParam(value="thumbprintAlgorithm") String var2, @PathParam(value="thumbprintInHexadecimal") String var3);

    @Named(value="DeleteServiceCertificate")
    @DELETE
    @Path(value="/{service}/certificates/{thumbprintAlgorithm}-{thumbprintInHexadecimal}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="service") String var1, @PathParam(value="thumbprintAlgorithm") String var2, @PathParam(value="thumbprintInHexadecimal") String var3);

    @Named(value="AddServiceCertificate")
    @POST
    @Path(value="/{service}/certificates")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String add(@PathParam(value="service") String var1, @BinderParam(value=ServiceCertificateParamsToXML.class) ServiceCertificateParams var2);
}

