/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.OSImageParamsToXML;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.OSImageParams;
import org.jclouds.azurecompute.functions.OSImageParamsName;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListOSImagesHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/images")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
public interface OSImageApi {
    @Named(value="ListImages")
    @GET
    @Produces(value={"application/xml"})
    @XMLResponseParser(value=ListOSImagesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<OSImage> list();

    @Named(value="AddImage")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String add(@BinderParam(value=OSImageParamsToXML.class) OSImageParams var1);

    @Named(value="UpdateImage")
    @PUT
    @Path(value="/{imageName}")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String update(@PathParam(value="imageName") @ParamParser(value=OSImageParamsName.class) @BinderParam(value=OSImageParamsToXML.class) OSImageParams var1);

    @Named(value="DeleteImage")
    @DELETE
    @Path(value="/{imageName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="imageName") String var1);
}

