/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.DeploymentParamsToXML;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.DeploymentParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.DeploymentHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/hostedservices/{serviceName}/deployments")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
public interface DeploymentApi {
    @Named(value="GetDeployment")
    @GET
    @Path(value="/{name}")
    @XMLResponseParser(value=DeploymentHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Deployment get(@PathParam(value="name") String var1);

    @Named(value="CreateVirtualMachineDeployment")
    @POST
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String create(@BinderParam(value=DeploymentParamsToXML.class) DeploymentParams var1);

    @Named(value="DeleteDeployment")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="name") String var1);
}

