/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.CreateAffinityGroupParamsToXML;
import org.jclouds.azurecompute.binders.UpdateAffinityGroupParamsToXML;
import org.jclouds.azurecompute.domain.AffinityGroup;
import org.jclouds.azurecompute.domain.CreateAffinityGroupParams;
import org.jclouds.azurecompute.domain.UpdateAffinityGroupParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.AffinityGroupHandler;
import org.jclouds.azurecompute.xml.ListAffinityGroupsHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/affinitygroups")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public interface AffinityGroupApi {
    @Named(value="ListAffinityGroups")
    @GET
    @XMLResponseParser(value=ListAffinityGroupsHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<AffinityGroup> list();

    @Named(value="GetAffinityGroup")
    @GET
    @Path(value="/{name}")
    @XMLResponseParser(value=AffinityGroupHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AffinityGroup get(@PathParam(value="name") String var1);

    @Named(value="AddAffinityGroup")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String add(@BinderParam(value=CreateAffinityGroupParamsToXML.class) CreateAffinityGroupParams var1);

    @Named(value="UpdateAffinityGroup")
    @PUT
    @Path(value="/{name}")
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String update(@PathParam(value="name") String var1, @BinderParam(value=UpdateAffinityGroupParamsToXML.class) UpdateAffinityGroupParams var2);

    @Named(value="DeleteAffinityGroup")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="name") String var1);
}

