/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_VMImageParams;
import org.jclouds.azurecompute.domain.AutoValue_VMImageParams_OSDiskConfigurationParams;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;

public abstract class VMImageParams {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String label();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract OSDiskConfigurationParams osDiskConfiguration();

    public abstract List<DataVirtualHardDisk> dataDiskConfiguration();

    @Nullable
    public abstract String language();

    @Nullable
    public abstract String imageFamily();

    @Nullable
    public abstract RoleSize.Type recommendedVMSize();

    @Nullable
    public abstract String eula();

    @Nullable
    public abstract URI iconUri();

    @Nullable
    public abstract URI smallIconUri();

    @Nullable
    public abstract URI privacyUri();

    @Nullable
    public abstract Boolean showGui();

    public Builder toBuilder() {
        return VMImageParams.builder().fromVMImageParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VMImageParams create(String name, String label, String description, OSDiskConfigurationParams osDiskConfiguration, List<DataVirtualHardDisk> dataDiskConfiguration, String language, String imageFamily, RoleSize.Type recommendedVMSize, String eula, URI iconUri, URI smallIconUri, URI privacyUri, Boolean showGui) {
        return new AutoValue_VMImageParams(name, label, description, osDiskConfiguration, dataDiskConfiguration, language, imageFamily, recommendedVMSize, eula, iconUri, smallIconUri, privacyUri, showGui);
    }

    public static final class Builder {
        private String name;
        private String label;
        private String description;
        private OSDiskConfigurationParams osDiskConfiguration;
        private List<DataVirtualHardDisk> dataDiskConfiguration = Lists.newArrayList();
        private String language;
        private String imageFamily;
        private RoleSize.Type recommendedVMSize;
        private String eula;
        private URI iconUri;
        private URI smallIconUri;
        private URI privacyUri;
        private Boolean showGui;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder osDiskConfiguration(OSDiskConfigurationParams osDiskConfig) {
            this.osDiskConfiguration = osDiskConfig;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder imageFamily(String imageFamily) {
            this.imageFamily = imageFamily;
            return this;
        }

        public Builder recommendedVMSize(RoleSize.Type recommendedRoleSize) {
            this.recommendedVMSize = recommendedRoleSize;
            return this;
        }

        public Builder showGui(Boolean showGui) {
            this.showGui = showGui;
            return this;
        }

        public Builder eula(String eula) {
            this.eula = eula;
            return this;
        }

        public Builder iconUri(URI iconUri) {
            this.iconUri = iconUri;
            return this;
        }

        public Builder smallIconUri(URI smallIconUri) {
            this.smallIconUri = smallIconUri;
            return this;
        }

        public Builder privacyUri(URI privacyUri) {
            this.privacyUri = this.smallIconUri;
            return this;
        }

        public Builder dataDiskConfiguration(DataVirtualHardDisk dataDiskConfiguration) {
            this.dataDiskConfiguration.add(dataDiskConfiguration);
            return this;
        }

        public Builder dataDiskConfigurations(Collection<DataVirtualHardDisk> dataDiskConfiguration) {
            this.dataDiskConfiguration.addAll(dataDiskConfiguration);
            return this;
        }

        public VMImageParams build() {
            return VMImageParams.create(this.name, this.label, this.description, this.osDiskConfiguration, this.dataDiskConfiguration, this.language, this.imageFamily, this.recommendedVMSize, this.eula, this.iconUri, this.smallIconUri, this.privacyUri, this.showGui);
        }

        public Builder fromVMImageParams(VMImageParams in) {
            return this.name(in.name()).label(in.label()).description(in.description()).osDiskConfiguration(in.osDiskConfiguration()).dataDiskConfigurations(in.dataDiskConfiguration()).language(in.language()).imageFamily(in.imageFamily()).recommendedVMSize(in.recommendedVMSize()).eula(in.eula()).iconUri(in.iconUri()).smallIconUri(in.smallIconUri()).privacyUri(in.privacyUri());
        }
    }

    public static abstract class OSDiskConfigurationParams {
        @Nullable
        public abstract String name();

        @Nullable
        public abstract Caching hostCaching();

        @Nullable
        public abstract OSState osState();

        public abstract OSImage.Type os();

        @Nullable
        public abstract URI mediaLink();

        @Nullable
        public abstract Integer logicalSizeInGB();

        @Nullable
        public abstract String ioType();

        public static OSDiskConfigurationParams OSDiskConfiguration(String name, Caching hostCaching, OSState osState, OSImage.Type os, URI mediaLink, Integer logicalDiskSizeInGB, String ioType) {
            return new AutoValue_VMImageParams_OSDiskConfigurationParams(name, hostCaching, osState, os, mediaLink, logicalDiskSizeInGB, ioType);
        }

        public static enum OSState {
            GENERALIZED,
            SPECIALIZED;

        }

        public static enum Caching {
            READ_ONLY,
            READ_WRITE,
            NONE;

        }
    }
}

