/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.domain.AutoValue_UpdateStorageServiceParams;
import org.jclouds.azurecompute.domain.AutoValue_UpdateStorageServiceParams_CustomDomain;
import org.jclouds.javax.annotation.Nullable;

public abstract class UpdateStorageServiceParams {
    UpdateStorageServiceParams() {
    }

    @Nullable
    public abstract String label();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract Boolean geoReplicationEnabled();

    @Nullable
    public abstract Map<String, String> extendedProperties();

    @Nullable
    public abstract List<CustomDomain> customDomains();

    @Nullable
    public abstract AccountType accountType();

    public Builder toBuilder() {
        return UpdateStorageServiceParams.builder().fromUpdateStorageServiceParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static UpdateStorageServiceParams create(String label, String description, Boolean geoReplicationEnabled, Map<String, String> extendedProperties, List<CustomDomain> customDomains, AccountType accountType) {
        return new AutoValue_UpdateStorageServiceParams(label, description, geoReplicationEnabled, (Map<String, String>)(extendedProperties == null ? null : ImmutableMap.copyOf(extendedProperties)), (List<CustomDomain>)(customDomains == null ? null : ImmutableList.copyOf(customDomains)), accountType);
    }

    public static final class Builder {
        private String label;
        private String description;
        private Boolean geoReplicationEnabled;
        private Map<String, String> extendedProperties;
        private List<CustomDomain> customDomains;
        private AccountType accountType;

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder geoReplicationEnabled(Boolean geoReplicationEnabled) {
            this.geoReplicationEnabled = geoReplicationEnabled;
            return this;
        }

        public Builder extendedProperties(Map<String, String> extendedProperties) {
            this.extendedProperties = extendedProperties;
            return this;
        }

        public Builder customDomains(List<CustomDomain> customDomains) {
            this.customDomains = customDomains;
            return this;
        }

        public Builder accountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public UpdateStorageServiceParams build() {
            return UpdateStorageServiceParams.create(this.label, this.description, this.geoReplicationEnabled, this.extendedProperties, this.customDomains, this.accountType);
        }

        public Builder fromUpdateStorageServiceParams(UpdateStorageServiceParams storageServiceParams) {
            return this.label(storageServiceParams.label()).description(storageServiceParams.description()).geoReplicationEnabled(storageServiceParams.geoReplicationEnabled()).extendedProperties(storageServiceParams.extendedProperties()).customDomains(storageServiceParams.customDomains()).accountType(storageServiceParams.accountType());
        }
    }

    public static abstract class CustomDomain {
        CustomDomain() {
        }

        public abstract String name();

        public abstract Boolean useSubDomainName();

        public static CustomDomain create(String name, boolean useSubDomainName) {
            return new AutoValue_UpdateStorageServiceParams_CustomDomain(name, useSubDomainName);
        }
    }

    public static enum AccountType {
        Standard_LRS,
        Standard_GRS,
        Standard_RAGRS;

    }
}

