/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.domain.AutoValue_StorageService;
import org.jclouds.azurecompute.domain.AutoValue_StorageService_StorageServiceProperties;
import org.jclouds.javax.annotation.Nullable;

public abstract class StorageService {
    StorageService() {
    }

    public abstract URL url();

    public abstract String serviceName();

    public abstract StorageServiceProperties storageServiceProperties();

    @Nullable
    public abstract Map<String, String> extendedProperties();

    @Nullable
    public abstract String capability();

    public static StorageService create(URL url, String serviceName, StorageServiceProperties storageServiceProperties, Map<String, String> extendedProperties, String capability) {
        return new AutoValue_StorageService(url, serviceName, storageServiceProperties, (Map<String, String>)(extendedProperties == null ? null : ImmutableMap.copyOf(extendedProperties)), capability);
    }

    public static abstract class StorageServiceProperties {
        StorageServiceProperties() {
        }

        @Nullable
        public abstract String description();

        @Nullable
        public abstract String affinityGroup();

        @Nullable
        public abstract String location();

        public abstract String label();

        public abstract Status status();

        @Nullable
        public abstract List<URL> endpoints();

        @Nullable
        public abstract String geoPrimaryRegion();

        @Nullable
        public abstract RegionStatus statusOfPrimary();

        @Nullable
        public abstract Date lastGeoFailoverTime();

        @Nullable
        public abstract String geoSecondaryRegion();

        @Nullable
        public abstract RegionStatus statusOfSecondary();

        public abstract Date creationTime();

        @Nullable
        public abstract List<String> customDomains();

        @Nullable
        public abstract List<URL> secondaryEndpoints();

        public abstract AccountType accountType();

        public static StorageServiceProperties create(String description, String affinityGroup, String location, String label, Status status, List<URL> endpoints, String geoPrimaryRegion, RegionStatus statusOfPrimary, Date lastGeoFailoverTime, String geoSecondaryRegion, RegionStatus statusOfSecondary, Date creationTime, List<String> customDomains, List<URL> secondaryEndpoints, AccountType accountType) {
            return new AutoValue_StorageService_StorageServiceProperties(description, affinityGroup, location, label, status, (List<URL>)(endpoints == null ? null : ImmutableList.copyOf(endpoints)), geoPrimaryRegion, statusOfPrimary, lastGeoFailoverTime, geoSecondaryRegion, statusOfSecondary, creationTime, customDomains, (List<URL>)(secondaryEndpoints == null ? null : ImmutableList.copyOf(secondaryEndpoints)), accountType);
        }
    }

    public static enum Status {
        Creating,
        Created,
        Deleting,
        Deleted,
        Changing,
        ResolvingDns,
        UNRECOGNIZED;


        public static Status fromString(String text) {
            if (text != null) {
                for (Status status : Status.values()) {
                    if (!text.equalsIgnoreCase(status.name())) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum RegionStatus {
        Available,
        Unavailable,
        UNRECOGNIZED;


        public static RegionStatus fromString(String text) {
            if (text != null) {
                for (RegionStatus status : RegionStatus.values()) {
                    if (!text.equalsIgnoreCase(status.name())) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum AccountType {
        Standard_LRS,
        Standard_ZRS,
        Standard_GRS,
        Standard_RAGRS,
        Premium_LRS,
        UNRECOGNIZED;


        public static AccountType fromString(String text) {
            if (text != null) {
                for (AccountType type : AccountType.values()) {
                    if (!text.equalsIgnoreCase(type.name())) continue;
                    return type;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

