/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_NetworkSecurityGroup;
import org.jclouds.azurecompute.domain.Rule;
import org.jclouds.javax.annotation.Nullable;

public abstract class NetworkSecurityGroup {
    NetworkSecurityGroup() {
    }

    public abstract String name();

    @Nullable
    public abstract String label();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract State state();

    @Nullable
    public abstract List<Rule> rules();

    public static NetworkSecurityGroup create(String name) {
        return new AutoValue_NetworkSecurityGroup(name, null, null, null, null);
    }

    public static NetworkSecurityGroup create(String name, String label, String location, State state, List<Rule> rules) {
        return new AutoValue_NetworkSecurityGroup(name, label, location, state, (List<Rule>)(rules == null ? ImmutableList.of() : ImmutableList.copyOf(rules)));
    }

    public static enum State {
        CREATED,
        CREATING,
        UPDATING,
        DELETING,
        UNAVAILABLE,
        UNRECOGNIZED;


        public static State fromString(String text) {
            if (text != null) {
                for (State status : State.values()) {
                    if (!text.equalsIgnoreCase(status.name())) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

