/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_NetworkConfiguration;
import org.jclouds.azurecompute.domain.AutoValue_NetworkConfiguration_AddressSpace;
import org.jclouds.azurecompute.domain.AutoValue_NetworkConfiguration_Subnet;
import org.jclouds.azurecompute.domain.AutoValue_NetworkConfiguration_VirtualNetworkConfiguration;
import org.jclouds.azurecompute.domain.AutoValue_NetworkConfiguration_VirtualNetworkSite;
import org.jclouds.javax.annotation.Nullable;

public abstract class NetworkConfiguration {
    public abstract VirtualNetworkConfiguration virtualNetworkConfiguration();

    public static NetworkConfiguration create(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        return new AutoValue_NetworkConfiguration(virtualNetworkConfiguration);
    }

    public static abstract class VirtualNetworkConfiguration {
        VirtualNetworkConfiguration() {
        }

        @Nullable
        public abstract String dns();

        @Nullable
        public abstract List<VirtualNetworkSite> virtualNetworkSites();

        public static VirtualNetworkConfiguration create(String dns, List<VirtualNetworkSite> virtualNetworkSites) {
            return new AutoValue_NetworkConfiguration_VirtualNetworkConfiguration(dns, (List<VirtualNetworkSite>)ImmutableList.copyOf(virtualNetworkSites));
        }
    }

    public static abstract class VirtualNetworkSite {
        VirtualNetworkSite() {
        }

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String name();

        @Nullable
        public abstract String location();

        public abstract AddressSpace addressSpace();

        public abstract List<Subnet> subnets();

        public static VirtualNetworkSite create(String id, String name, String location, AddressSpace addressSpace, List<Subnet> subnets) {
            return new AutoValue_NetworkConfiguration_VirtualNetworkSite(id, name, location, addressSpace, subnets);
        }
    }

    public static abstract class AddressSpace {
        AddressSpace() {
        }

        @Nullable
        public abstract String addressPrefix();

        public static AddressSpace create(String addressPrefix) {
            return new AutoValue_NetworkConfiguration_AddressSpace(addressPrefix);
        }
    }

    public static abstract class Subnet {
        Subnet() {
        }

        public abstract String name();

        @Nullable
        public abstract String addressPrefix();

        @Nullable
        public abstract String networkSecurityGroup();

        public static Subnet create(String name, String addressPrefix, String networkSecurityGroup) {
            return new AutoValue_NetworkConfiguration_Subnet(name, addressPrefix, networkSecurityGroup);
        }
    }
}

