/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_Deployment;
import org.jclouds.azurecompute.domain.AutoValue_Deployment_InstanceEndpoint;
import org.jclouds.azurecompute.domain.AutoValue_Deployment_RoleInstance;
import org.jclouds.azurecompute.domain.AutoValue_Deployment_VirtualIP;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;

public abstract class Deployment {
    Deployment() {
    }

    public abstract String name();

    public abstract Slot slot();

    public abstract Status status();

    public abstract String label();

    @Nullable
    public abstract String instanceStateDetails();

    @Nullable
    public abstract String instanceErrorCode();

    public abstract List<VirtualIP> virtualIPs();

    public abstract List<RoleInstance> roleInstanceList();

    @Nullable
    public abstract List<Role> roleList();

    @Nullable
    public abstract String virtualNetworkName();

    public static Deployment create(String name, Slot slot, Status status, String label, String instanceStateDetails, String instanceErrorCode, List<VirtualIP> virtualIPs, List<RoleInstance> roleInstanceList, List<Role> roles, String virtualNetworkName) {
        return new AutoValue_Deployment(name, slot, status, label, instanceStateDetails, instanceErrorCode, (List<VirtualIP>)ImmutableList.copyOf(virtualIPs), (List<RoleInstance>)ImmutableList.copyOf(roleInstanceList), (List<Role>)(roles == null ? null : ImmutableList.copyOf(roles)), virtualNetworkName);
    }

    public static abstract class RoleInstance {
        public abstract String roleName();

        public abstract String instanceName();

        public abstract InstanceStatus instanceStatus();

        public abstract PowerState powerState();

        @Nullable
        public abstract Integer instanceUpgradeDomain();

        @Nullable
        public abstract Integer instanceFaultDomain();

        @Nullable
        public abstract RoleSize.Type instanceSize();

        @Nullable
        public abstract String ipAddress();

        @Nullable
        public abstract String hostname();

        @Nullable
        public abstract List<InstanceEndpoint> instanceEndpoints();

        RoleInstance() {
        }

        public static RoleInstance create(String roleName, String instanceName, InstanceStatus instanceStatus, PowerState powerState, Integer instanceUpgradeDomain, Integer instanceFaultDomain, RoleSize.Type instanceSize, String ipAddress, String hostname, List<InstanceEndpoint> instanceEndpoints) {
            return new AutoValue_Deployment_RoleInstance(roleName, instanceName, instanceStatus, powerState, instanceUpgradeDomain, instanceFaultDomain, instanceSize, ipAddress, hostname, (List<InstanceEndpoint>)(instanceEndpoints == null ? null : ImmutableList.copyOf(instanceEndpoints)));
        }
    }

    public static abstract class InstanceEndpoint {
        public abstract String name();

        public abstract String vip();

        public abstract int publicPort();

        public abstract int localPort();

        public abstract String protocol();

        InstanceEndpoint() {
        }

        public static InstanceEndpoint create(String name, String vip, int publicPort, int localPort, String protocol) {
            return new AutoValue_Deployment_InstanceEndpoint(name, vip, publicPort, localPort, protocol);
        }
    }

    public static abstract class VirtualIP {
        public abstract String address();

        public abstract Boolean isDnsProgrammed();

        public abstract String name();

        VirtualIP() {
        }

        public static VirtualIP create(String address, Boolean isDnsProgrammed, String name) {
            return new AutoValue_Deployment_VirtualIP(address, isDnsProgrammed, name);
        }
    }

    public static enum PowerState {
        STARTING("Starting"),
        STARTED("Started"),
        STOPPING("Stopping"),
        STOPPED("Stopped"),
        UNKNOWN("Unknown"),
        UNRECOGNIZED("");

        private final String key;

        private PowerState(String key) {
            this.key = key;
        }

        public static PowerState fromString(String text) {
            if (text != null) {
                for (PowerState state : PowerState.values()) {
                    if (!text.equalsIgnoreCase(state.key)) continue;
                    return state;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum InstanceStatus {
        ROLE_STATE_UNKNOWN("RoleStateUnknown"),
        CREATING_VM("CreatingVM"),
        STARTING_VM("StartingVM"),
        CREATING_ROLE("CreatingRole"),
        STARTING_ROLE("StartingRole"),
        READY_ROLE("ReadyRole", false),
        BUSY_ROLE("BusyRole"),
        STOPPING_ROLE("StoppingRole"),
        STOPPING_VM("StoppingVM"),
        STOPPED_DEALLOCATED("StoppedDeallocated", false),
        PREPARING("Preparing"),
        DELETING_VM("DeletingVM"),
        STOPPED_VM("StoppedVM", false),
        RESTARTING_ROLE("RestartingRole"),
        CYCLING_ROLE("CyclingRole"),
        FAILED_STARTING_ROLE("FailedStartingRole", false),
        FAILED_STARTING_VM("FailedStartingVM", false),
        UNRESPONSIVE_ROLE("UnresponsiveRole"),
        PROVISIONING("Provisioning"),
        PROVISIONING_FAILED("ProvisioningFailed", false),
        UNRECOGNIZED("");

        private final String key;
        private final boolean _transient;

        private InstanceStatus(String key) {
            this(key, true);
        }

        private InstanceStatus(String key, boolean _transient) {
            this.key = key;
            this._transient = _transient;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public static InstanceStatus fromString(String text) {
            if (text != null) {
                for (InstanceStatus status : InstanceStatus.values()) {
                    if (!text.equalsIgnoreCase(status.key)) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum Status {
        RUNNING("Running"),
        SUSPENDED("Suspended"),
        RUNNING_TRANSITIONING("RunningTransitioning"),
        SUSPENDED_TRANSITIONING("SuspendedTransitioning"),
        STARTING("Starting"),
        SUSPENDING("Suspending"),
        DEPLOYING("Deploying"),
        DELETING("Deleting"),
        UNRECOGNIZED("");

        private final String key;

        private Status(String key) {
            this.key = key;
        }

        public static Status fromString(String text) {
            if (text != null) {
                for (Status status : Status.values()) {
                    if (!text.equalsIgnoreCase(status.key)) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }

    public static enum Slot {
        PRODUCTION,
        STAGING,
        UNRECOGNIZED;


        public static Slot fromString(String text) {
            if (text != null) {
                for (Slot slot : Slot.values()) {
                    if (!text.equalsIgnoreCase(slot.name())) continue;
                    return slot;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

