/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azurecompute.domain.Region;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class LocationToLocation
implements Function<org.jclouds.azurecompute.domain.Location, Location> {
    private final JustProvider justProvider;

    @Inject
    LocationToLocation(JustProvider justProvider) {
        this.justProvider = justProvider;
    }

    public Location apply(org.jclouds.azurecompute.domain.Location location) {
        LocationBuilder builder = new LocationBuilder();
        builder.id(location.name());
        builder.description(location.displayName());
        builder.parent((Location)Iterables.getOnlyElement((Iterable)this.justProvider.get()));
        builder.scope(LocationScope.REGION);
        Region region = Region.byName(location.name());
        if (region != null) {
            builder.iso3166Codes((Iterable)ImmutableSet.of((Object)region.iso3166Code()));
        }
        return builder.build();
    }
}

