/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.compute.functions.OSImageToImage;
import org.jclouds.azurecompute.compute.functions.RoleSizeToHardware;
import org.jclouds.azurecompute.domain.CloudService;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;

public class DeploymentToNodeMetadata
implements Function<Deployment, NodeMetadata> {
    private static final Map<Deployment.InstanceStatus, NodeMetadata.Status> INSTANCESTATUS_TO_NODESTATUS = ImmutableMap.builder().put((Object)Deployment.InstanceStatus.BUSY_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.CREATING_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.CREATING_VM, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.CYCLING_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.DELETING_VM, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.FAILED_STARTING_ROLE, (Object)NodeMetadata.Status.ERROR).put((Object)Deployment.InstanceStatus.FAILED_STARTING_VM, (Object)NodeMetadata.Status.ERROR).put((Object)Deployment.InstanceStatus.PREPARING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.PROVISIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.READY_ROLE, (Object)NodeMetadata.Status.RUNNING).put((Object)Deployment.InstanceStatus.RESTARTING_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.STARTING_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.STARTING_VM, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.STOPPED_DEALLOCATED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Deployment.InstanceStatus.STOPPED_VM, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Deployment.InstanceStatus.STOPPING_ROLE, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.STOPPING_VM, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.InstanceStatus.ROLE_STATE_UNKNOWN, (Object)NodeMetadata.Status.UNRECOGNIZED).put((Object)Deployment.InstanceStatus.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private static final Map<Deployment.Status, NodeMetadata.Status> STATUS_TO_NODESTATUS = ImmutableMap.builder().put((Object)Deployment.Status.DELETING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.Status.SUSPENDED_TRANSITIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.Status.RUNNING_TRANSITIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.Status.DEPLOYING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.Status.STARTING, (Object)NodeMetadata.Status.PENDING).put((Object)Deployment.Status.SUSPENDED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Deployment.Status.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)Deployment.Status.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final AzureComputeApi api;
    private final Supplier<Set<? extends Location>> locations;
    private final GroupNamingConvention nodeNamingConvention;
    private final OSImageToImage osImageToImage;
    private final RoleSizeToHardware roleSizeToHardware;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DeploymentToNodeMetadata(AzureComputeApi api, @Memoized Supplier<Set<? extends Location>> locations, GroupNamingConvention.Factory namingConvention, OSImageToImage osImageToImage, RoleSizeToHardware roleSizeToHardware, Map<String, Credentials> credentialStore) {
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.osImageToImage = osImageToImage;
        this.roleSizeToHardware = roleSizeToHardware;
        this.credentialStore = credentialStore;
        this.api = api;
    }

    public NodeMetadata apply(Deployment from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(from.name());
        builder.providerId(from.name());
        builder.name(from.name());
        builder.hostname(this.getHostname(from));
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(this.getHostname(from)));
        CloudService cloudService = this.api.getCloudServiceApi().get(from.name());
        if (cloudService != null) {
            String location = cloudService.location() != null ? cloudService.location() : this.api.getAffinityGroupApi().get(cloudService.affinityGroup()).location();
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)location)).orNull());
        }
        if (from.status() != null) {
            Optional<Deployment.RoleInstance> roleInstance = this.tryFindFirstRoleInstanceInDeployment(from);
            if (roleInstance.isPresent() && ((Deployment.RoleInstance)roleInstance.get()).instanceStatus() != null) {
                builder.status(INSTANCESTATUS_TO_NODESTATUS.get((Object)((Deployment.RoleInstance)roleInstance.get()).instanceStatus()));
            } else {
                builder.status(STATUS_TO_NODESTATUS.get((Object)from.status()));
            }
        } else {
            builder.status(NodeMetadata.Status.UNRECOGNIZED);
        }
        LinkedHashSet publicIpAddresses = Sets.newLinkedHashSet();
        if (from.virtualIPs() != null) {
            for (Deployment.VirtualIP virtualIP : from.virtualIPs()) {
                publicIpAddresses.add(virtualIP.address());
            }
            builder.publicAddresses((Iterable)publicIpAddresses);
        }
        LinkedHashSet privateIpAddresses = Sets.newLinkedHashSet();
        if (from.roleInstanceList() != null) {
            for (Deployment.RoleInstance roleInstance : from.roleInstanceList()) {
                if (roleInstance.ipAddress() == null) continue;
                privateIpAddresses.add(roleInstance.ipAddress());
            }
            builder.privateAddresses((Iterable)privateIpAddresses);
        }
        return builder.build();
    }

    private String getHostname(Deployment from) {
        Optional<Deployment.RoleInstance> roleInstance = this.tryFindFirstRoleInstanceInDeployment(from);
        return !roleInstance.isPresent() || ((Deployment.RoleInstance)roleInstance.get()).hostname() == null ? from.name() : ((Deployment.RoleInstance)roleInstance.get()).hostname();
    }

    private Optional<Deployment.RoleInstance> tryFindFirstRoleInstanceInDeployment(Deployment deployment) {
        return deployment.roleInstanceList() == null || deployment.roleInstanceList().isEmpty() ? Optional.absent() : Optional.of((Object)deployment.roleInstanceList().get(0));
    }
}

