/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.OSImageParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class OSImageParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        OSImageParams params = (OSImageParams)OSImageParams.class.cast(input);
        try {
            String xml = XMLBuilder.create((String)"OSImage", (String)"http://schemas.microsoft.com/windowsazure").e("Label").t(params.label()).up().e("MediaLink").t(params.mediaLink().toASCIIString()).up().e("Name").t(params.name()).up().e("OS").t(params.os() == OSImage.Type.LINUX ? "Linux" : "Windows").up().up().asString();
            return (R)((HttpRequest.Builder)request.toBuilder().payload(xml)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

