/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.CaptureVMImageParams;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class CaptureVMImageParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        CaptureVMImageParams params = (CaptureVMImageParams)CaptureVMImageParams.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"CaptureRoleAsVMImageOperation", (String)"http://schemas.microsoft.com/windowsazure").namespace("i", "http://www.w3.org/2001/XMLSchema-instance").e("OperationType").t("CaptureRoleAsVMImageOperation").up().e("OSState").t(params.osState() == VMImage.OSDiskConfiguration.OSState.GENERALIZED ? "Generalized" : "Specialized").up().e("VMImageName").t(params.name()).up().e("VMImageLabel").t(params.label()).up();
            this.add(builder, "Description", params.description());
            this.add(builder, "Language", params.language());
            this.add(builder, "ImageFamily", params.imageFamily());
            RoleSize.Type vmSize = params.recommendedVMSize();
            if (vmSize != null) {
                String vmSizeText = params.recommendedVMSize().getText();
                builder.e("RecommendedVMSize").t(vmSizeText).up();
            }
            builder.up();
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private XMLBuilder add(XMLBuilder xmlBuilder, String entity, String text) {
        if (text != null) {
            return xmlBuilder.e(entity).t(text).up();
        }
        return xmlBuilder.e(entity).up();
    }
}

