/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.azurecompute.AzureManagementApiMetadata;
import org.jclouds.azurecompute.domain.Region;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

@AutoService(value=ProviderMetadata.class)
public class AzureComputeProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AzureComputeProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public AzureComputeProviderMetadata() {
        super((BaseProviderMetadata.Builder)AzureComputeProviderMetadata.builder());
    }

    public static Properties defaultProperties() {
        Properties properties = AzureManagementApiMetadata.defaultProperties();
        properties.setProperty("jclouds.azurecompute.operation.timeout", "60000");
        properties.setProperty("jclouds.azurecompute..operation.poll.initial.period", "5");
        properties.setProperty("jclouds.azurecompute.operation.poll.max.period", "15");
        properties.setProperty("jclouds.azurecompute.tcp.rule.format", "tcp_%s-%s");
        properties.setProperty("jclouds.azurecompute.tcp.rule.regexp", "tcp_\\d{1,5}-\\d{1,5}");
        properties.setProperty("jclouds.azurecompute.deallocate.when.suspending", "true");
        return properties;
    }

    public AzureComputeProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("azurecompute").name("Microsoft Azure Service Management Service").apiMetadata((ApiMetadata)new AzureManagementApiMetadata()).endpoint("https://management.core.windows.net/SUBSCRIPTION_ID").homepage(URI.create("https://www.windowsazure.com/")).console(URI.create("https://windows.azure.com/default.aspx")).linkedServices(new String[]{"azureblob", "azurequeue", "azuretable"}).iso3166Codes(Region.iso3166Codes()).defaultProperties(AzureComputeProviderMetadata.defaultProperties());
        }

        public AzureComputeProviderMetadata build() {
            return new AzureComputeProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata providerMetadata) {
            super.fromProviderMetadata(providerMetadata);
            return this;
        }
    }
}

