/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.methods;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Callables;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslAccessible;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslFunctionSource;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslToStringHelpers;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.core.xstream.ObjectWithDefaultStringImplConverter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class DslComponent
extends BrooklynDslDeferredSupplier<Entity>
implements DslFunctionSource {
    private static final long serialVersionUID = -7715984495268724954L;
    private final String componentId;
    private final DeferredSupplier<?> componentIdSupplier;
    private final DslComponent scopeComponent;
    private final Scope scope;

    public static DslComponent newInstance(DslComponent scopeComponent, Scope scope, Object componentId) {
        if (DslUtils.resolved(componentId)) {
            return new DslComponent(scopeComponent, scope, (String)componentId);
        }
        return new DslComponent(scopeComponent, scope, (DeferredSupplier)componentId);
    }

    public static DslComponent newInstance(Scope scope, Object componentId) {
        if (DslUtils.resolved(componentId)) {
            return new DslComponent(scope, (String)componentId);
        }
        return new DslComponent(scope, (DeferredSupplier)componentId);
    }

    @Deprecated
    public DslComponent(String componentId) {
        this(Scope.GLOBAL, componentId);
    }

    public DslComponent(Scope scope) {
        this(null, scope);
    }

    public DslComponent(DslComponent scopeComponent, Scope scope) {
        this(scopeComponent, scope, (String)null);
    }

    public DslComponent(Scope scope, String componentId) {
        this(null, scope, componentId);
    }

    public DslComponent(Scope scope, DeferredSupplier<?> componentIdSupplier) {
        this(null, scope, componentIdSupplier);
    }

    public DslComponent(DslComponent scopeComponent, Scope scope, String componentId) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.scopeComponent = scopeComponent;
        this.componentId = componentId;
        this.componentIdSupplier = null;
        this.scope = scope;
    }

    public DslComponent(DslComponent scopeComponent, Scope scope, DeferredSupplier<?> componentIdSupplier) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.scopeComponent = scopeComponent;
        this.componentId = null;
        this.componentIdSupplier = componentIdSupplier;
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public final Maybe<Entity> getImmediately() {
        return new EntityInScopeFinder(this.scopeComponent, this.scope, this.componentId, this.componentIdSupplier).getImmediately();
    }

    @Override
    public Task<Entity> newTask() {
        return TaskBuilder.builder().displayName(this.toString()).tag((Object)"TRANSIENT").body((Callable)new EntityInScopeFinder(this.scopeComponent, this.scope, this.componentId, this.componentIdSupplier)).build();
    }

    static ExecutionContext findExecutionContext(Object callerContext) {
        BasicExecutionContext execContext;
        EntityInternal contextEntity = (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
        Object object = execContext = contextEntity != null ? contextEntity.getExecutionContext() : BasicExecutionContext.getCurrentExecutionContext();
        if (execContext == null) {
            throw new IllegalStateException("No execution context available to resolve " + callerContext);
        }
        return execContext;
    }

    @DslAccessible
    public DslComponent entity(Object id) {
        return DslComponent.newInstance(this, Scope.GLOBAL, id);
    }

    @DslAccessible
    public DslComponent child(Object id) {
        return DslComponent.newInstance(this, Scope.CHILD, id);
    }

    @DslAccessible
    public DslComponent sibling(Object id) {
        return DslComponent.newInstance(this, Scope.SIBLING, id);
    }

    @DslAccessible
    public DslComponent descendant(Object id) {
        return DslComponent.newInstance(this, Scope.DESCENDANT, id);
    }

    @DslAccessible
    public DslComponent ancestor(Object id) {
        return DslComponent.newInstance(this, Scope.ANCESTOR, id);
    }

    @DslAccessible
    public DslComponent root() {
        return new DslComponent(this, Scope.ROOT);
    }

    @DslAccessible
    public DslComponent scopeRoot() {
        return new DslComponent(this, Scope.SCOPE_ROOT);
    }

    @Deprecated
    @DslAccessible
    public DslComponent component(Object id) {
        return DslComponent.newInstance(this, Scope.GLOBAL, id);
    }

    @DslAccessible
    public DslComponent self() {
        return new DslComponent(this, Scope.THIS);
    }

    @DslAccessible
    public DslComponent parent() {
        return new DslComponent(this, Scope.PARENT);
    }

    @DslAccessible
    public DslComponent component(String scope, Object id) {
        if (!Scope.isValid(scope)) {
            throw new IllegalArgumentException(scope + " is not a valid scope");
        }
        return DslComponent.newInstance(this, Scope.fromString(scope), id);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> entityId() {
        return new EntityId(this);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> attributeWhenReady(Object sensorNameOrSupplier) {
        return new AttributeWhenReady(this, sensorNameOrSupplier);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> config(Object keyNameOrSupplier) {
        return new DslConfigSupplier(this, keyNameOrSupplier);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<Sensor<?>> sensor(Object sensorIndicator) {
        return new DslSensorSupplier(this, sensorIndicator);
    }

    public Object template(Object template) {
        return new DslTemplate(this, template);
    }

    public Object template(Object template, Map<?, ?> substitutions) {
        return new DslTemplate(this, template, substitutions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.componentId, this.scopeComponent, this.scope});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DslComponent that = (DslComponent)DslComponent.class.cast(obj);
        return Objects.equal((Object)this.componentId, (Object)that.componentId) && Objects.equal((Object)this.scopeComponent, (Object)that.scopeComponent) && Objects.equal((Object)((Object)this.scope), (Object)((Object)that.scope));
    }

    public String toString() {
        DeferredSupplier<?> component;
        DeferredSupplier<?> deferredSupplier = component = this.componentId != null ? this.componentId : this.componentIdSupplier;
        if (this.scope == Scope.GLOBAL) {
            return DslToStringHelpers.fn("entity", component);
        }
        if (this.scope == Scope.THIS) {
            if (this.scopeComponent != null) {
                return this.scopeComponent.toString();
            }
            return DslToStringHelpers.fn("entity", "this", "");
        }
        String remainder = component == null || "".equals(component) ? DslToStringHelpers.fn(this.scope.toString(), new Object[0]) : DslToStringHelpers.fn(this.scope.toString(), component);
        return DslToStringHelpers.component(this.scopeComponent, remainder);
    }

    public static enum Scope {
        GLOBAL,
        CHILD,
        PARENT,
        SIBLING,
        DESCENDANT,
        ANCESTOR,
        ROOT,
        SCOPE_ROOT,
        THIS;

        private static Converter<String, String> converter;

        public static Scope fromString(String name) {
            Maybe<Scope> parsed = Scope.tryFromString(name);
            return (Scope)((Object)parsed.get());
        }

        public static Maybe<Scope> tryFromString(String name) {
            try {
                Scope scope = Scope.valueOf((String)converter.convert((Object)name));
                return Maybe.of((Object)((Object)scope));
            }
            catch (Exception cause) {
                return Maybe.absent((Throwable)cause);
            }
        }

        public static boolean isValid(String name) {
            Maybe<Scope> check = Scope.tryFromString(name);
            return check.isPresentAndNonNull();
        }

        public String toString() {
            return (String)converter.reverse().convert((Object)this.name());
        }

        static {
            converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        }
    }

    protected static final class DslTemplate
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -585564936781673667L;
        private DslComponent component;
        private Object template;
        private Map<?, ?> substitutions;

        public DslTemplate(DslComponent component, Object template) {
            this(component, template, (Map<?, ?>)ImmutableMap.of());
        }

        public DslTemplate(DslComponent component, Object template, Map<?, ?> substitutions) {
            this.component = component;
            this.template = template;
            this.substitutions = substitutions;
        }

        private String resolveTemplate(boolean immediately) {
            if (this.template instanceof String) {
                return (String)this.template;
            }
            return (String)Tasks.resolving((Object)this.template).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving template from " + this.template).get();
        }

        private Map<String, ?> resolveSubstitutions(boolean immediately) {
            return (Map)Tasks.resolving(this.substitutions).as(Object.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).deep(true).description("Resolving substitutions " + this.substitutions + " for template " + this.template).get();
        }

        public Maybe<Object> getImmediately() {
            String resolvedTemplate = this.resolveTemplate(true);
            Map<String, ?> resolvedSubstitutions = this.resolveSubstitutions(true);
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            String evaluatedTemplate = TemplateProcessor.processTemplateContents((String)resolvedTemplate, (EntityInternal)((EntityInternal)targetEntity), resolvedSubstitutions);
            return Maybe.of((Object)evaluatedTemplate);
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("evaluating template " + this.template).dynamic(false).body((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity = (Entity)component.get();
                    Map resolvedSubstitutions = this.resolveSubstitutions(false);
                    return TemplateProcessor.processTemplateContents((String)this.resolveTemplate(false), (EntityInternal)((EntityInternal)targetEntity), (Map)resolvedSubstitutions);
                }
            }).build();
        }
    }

    protected static final class DslSensorSupplier
    extends BrooklynDslDeferredSupplier<Sensor<?>> {
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object sensorName;
        private static final long serialVersionUID = -4735177561947722511L;

        public DslSensorSupplier(DslComponent component, Object sensorIndicator) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorIndicator;
        }

        public Maybe<Sensor<?>> getImmediately() {
            return this.getImmediately(this.sensorName, false);
        }

        protected Maybe<Sensor<?>> getImmediately(Object si, boolean resolved) {
            if (si instanceof Sensor) {
                return Maybe.of((Object)((Sensor)si));
            }
            if (si instanceof String) {
                Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
                if (targetEntityMaybe.isAbsent()) {
                    return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
                }
                Entity targetEntity = (Entity)targetEntityMaybe.get();
                Sensor result = null;
                if (targetEntity != null) {
                    result = targetEntity.getEntityType().getSensor((String)si);
                }
                if (result != null) {
                    return Maybe.of(result);
                }
                return Maybe.of((Object)Sensors.newSensor(Object.class, (String)((String)si)));
            }
            if (!resolved) {
                ExecutionContext executionContext = DslSensorSupplier.entity().getExecutionContext();
                Maybe resolvedSi = Tasks.resolving((Object)si, Object.class).deep(true).immediately(true).context(executionContext).getMaybe();
                if (resolvedSi.isAbsent()) {
                    return Maybe.absent();
                }
                return this.getImmediately(resolvedSi.get(), true);
            }
            throw new IllegalStateException("Cannot resolve '" + this.sensorName + "' as a sensor (got type " + (si == null ? "null" : si.getClass().getName() + ")"));
        }

        @Override
        public Task<Sensor<?>> newTask() {
            return Tasks.builder().displayName("looking up sensor for " + this.sensorName).dynamic(false).body(new Callable<Sensor<?>>(){

                @Override
                public Sensor<?> call() throws Exception {
                    return this.resolve(sensorName, false);
                }

                public Sensor<?> resolve(Object si, boolean resolved) throws ExecutionException, InterruptedException {
                    if (si instanceof Sensor) {
                        return (Sensor)si;
                    }
                    if (si instanceof String) {
                        Entity targetEntity = (Entity)component.get();
                        Sensor result = null;
                        if (targetEntity != null) {
                            result = targetEntity.getEntityType().getSensor((String)si);
                        }
                        if (result != null) {
                            return result;
                        }
                        return Sensors.newSensor(Object.class, (String)((String)si));
                    }
                    if (!resolved) {
                        ExecutionContext executionContext = DslSensorSupplier.entity().getExecutionContext();
                        return this.resolve(Tasks.resolveDeepValue((Object)si, Object.class, (ExecutionContext)executionContext), true);
                    }
                    throw new IllegalStateException("Cannot resolve '" + sensorName + "' as a sensor (got type " + (si == null ? "null" : si.getClass().getName() + ")"));
                }
            }).build();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.sensorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslSensorSupplier that = (DslSensorSupplier)DslSensorSupplier.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.sensorName, (Object)that.sensorName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("sensorName", this.sensorName instanceof Sensor ? ((Sensor)this.sensorName).getName() : this.sensorName));
        }
    }

    protected static final class DslConfigSupplier
    extends BrooklynDslDeferredSupplier<Object> {
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object keyName;
        private static final long serialVersionUID = -4735177561947722511L;

        public DslConfigSupplier(DslComponent component, Object keyName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.keyName = keyName;
        }

        protected String resolveKeyName(boolean immediately) {
            if (this.keyName instanceof String) {
                return (String)this.keyName;
            }
            return (String)Tasks.resolving((Object)this.keyName).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving key name from " + this.keyName).get();
        }

        public final Maybe<Object> getImmediately() {
            Maybe maybeWrappedMaybe = DslComponent.findExecutionContext(this).getImmediately(this.newCallableReturningImmediateMaybeOrNonImmediateValue(true));
            if (maybeWrappedMaybe.isAbsent()) {
                return maybeWrappedMaybe;
            }
            return Maybe.cast((Maybe)((Maybe)maybeWrappedMaybe.get()));
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("retrieving config for " + this.keyName).tag((Object)"TRANSIENT").dynamic(false).body(this.newCallableReturningImmediateMaybeOrNonImmediateValue(false)).build();
        }

        private Callable<Object> newCallableReturningImmediateMaybeOrNonImmediateValue(final boolean immediate) {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity;
                    if (immediate) {
                        Maybe<Entity> targetEntityMaybe = component.getImmediately();
                        if (targetEntityMaybe.isAbsent()) {
                            return Maybe.cast(targetEntityMaybe);
                        }
                        targetEntity = (EntityInternal)targetEntityMaybe.get();
                    } else {
                        targetEntity = (Entity)component.get();
                    }
                    this.checkAndTagForRecursiveReference(targetEntity);
                    String keyNameS = this.resolveKeyName(true);
                    ConfigKey key = targetEntity.getEntityType().getConfigKey(keyNameS);
                    if (key == null) {
                        key = ConfigKeys.newConfigKey(Object.class, (String)keyNameS);
                    }
                    if (immediate) {
                        return ((EntityInternal)targetEntity).config().getNonBlocking(key);
                    }
                    return targetEntity.getConfig(key);
                }
            };
        }

        private void checkAndTagForRecursiveReference(Entity targetEntity) {
            String tag = "DSL:entity('" + targetEntity.getId() + "').config('" + this.keyName + "')";
            Task ancestor = Tasks.current();
            if (ancestor != null) {
                ancestor = ancestor.getSubmittedByTask();
            }
            while (ancestor != null) {
                if (TaskTags.hasTag((Task)ancestor, (Object)tag)) {
                    throw new IllegalStateException("Recursive config reference " + tag);
                }
                ancestor = ancestor.getSubmittedByTask();
            }
            Tasks.addTagDynamically((Object)tag);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.keyName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslConfigSupplier that = (DslConfigSupplier)DslConfigSupplier.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.keyName, (Object)that.keyName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("config", this.keyName));
        }
    }

    protected static class AttributeWhenReady
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 1740899524088902383L;
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object sensorName;

        public AttributeWhenReady(DslComponent component, Object sensorName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorName;
        }

        protected String resolveSensorName(boolean immediately) {
            if (this.sensorName instanceof String) {
                return (String)this.sensorName;
            }
            return (String)Tasks.resolving((Object)this.sensorName).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving sensorName from " + this.sensorName).get();
        }

        public final Maybe<Object> getImmediately() {
            Object result;
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            String sensorNameS = this.resolveSensorName(true);
            AttributeSensor targetSensor = (AttributeSensor)targetEntity.getEntityType().getSensor(sensorNameS);
            if (targetSensor == null) {
                targetSensor = Sensors.newSensor(Object.class, (String)sensorNameS);
            }
            return JavaGroovyEquivalents.groovyTruth((Object)(result = targetEntity.sensors().get(targetSensor))) ? Maybe.of((Object)result) : ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWithExceptionSupplier();
        }

        @Override
        public Task<Object> newTask() {
            Entity targetEntity = (Entity)this.component.get();
            String sensorNameS = this.resolveSensorName(false);
            Sensor targetSensor = targetEntity.getEntityType().getSensor(sensorNameS);
            if (!(targetSensor instanceof AttributeSensor)) {
                targetSensor = Sensors.newSensor(Object.class, (String)sensorNameS);
            }
            return DependentConfiguration.attributeWhenReady((Entity)targetEntity, (AttributeSensor)((AttributeSensor)targetSensor));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.sensorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeWhenReady that = (AttributeWhenReady)AttributeWhenReady.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.sensorName, (Object)that.sensorName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("attributeWhenReady", this.sensorName));
        }
    }

    protected static class EntityId
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -419427634694971033L;
        private final DslComponent component;

        public EntityId(DslComponent component) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
        }

        public Maybe<Object> getImmediately() {
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            return Maybe.of((Object)targetEntity.getId());
        }

        @Override
        public Task<Object> newTask() {
            Entity targetEntity = (Entity)this.component.get();
            return Tasks.create((String)"identity", (Callable)Callables.returning((Object)targetEntity.getId()));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityId that = (EntityId)EntityId.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("entityId", new Object[0]));
        }
    }

    protected static class EntityInScopeFinder
    implements Callable<Entity>,
    ImmediateSupplier<Entity> {
        protected final DslComponent scopeComponent;
        protected final Scope scope;
        protected final String componentId;
        protected final DeferredSupplier<?> componentIdSupplier;

        public EntityInScopeFinder(DslComponent scopeComponent, Scope scope, String componentId, DeferredSupplier<?> componentIdSupplier) {
            this.scopeComponent = scopeComponent;
            this.scope = scope;
            this.componentId = componentId;
            this.componentIdSupplier = componentIdSupplier;
        }

        public Maybe<Entity> getImmediately() {
            try {
                return this.callImpl(true);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public Entity get() {
            try {
                return this.call();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        @Override
        public Entity call() throws Exception {
            return (Entity)this.callImpl(false).get();
        }

        protected Maybe<Entity> getEntity(boolean immediate) {
            if (this.scopeComponent != null) {
                if (immediate) {
                    return this.scopeComponent.getImmediately();
                }
                return Maybe.of(this.scopeComponent.get());
            }
            return Maybe.ofDisallowingNull((Object)DslComponent.entity()).or(Maybe.absent((String)"Context entity not available when trying to evaluate Brooklyn DSL"));
        }

        protected Maybe<Entity> callImpl(boolean immediate) throws Exception {
            Optional result;
            String desiredComponentId;
            Maybe<Entity> entityMaybe = this.getEntity(immediate);
            if (immediate && entityMaybe.isAbsent()) {
                return entityMaybe;
            }
            EntityInternal entity = (EntityInternal)entityMaybe.get();
            Iterable entitiesToSearch = null;
            Predicate notSelfPredicate = Predicates.not((Predicate)Predicates.equalTo((Object)entity));
            switch (this.scope) {
                case THIS: {
                    return Maybe.of((Object)entity);
                }
                case PARENT: {
                    return Maybe.of((Object)entity.getParent());
                }
                case GLOBAL: {
                    entitiesToSearch = ((EntityManagerInternal)entity.getManagementContext().getEntityManager()).getAllEntitiesInApplication(DslComponent.entity().getApplication());
                    break;
                }
                case ROOT: {
                    return Maybe.of((Object)entity.getApplication());
                }
                case SCOPE_ROOT: {
                    return Maybe.of((Object)Entities.catalogItemScopeRoot((Entity)entity));
                }
                case DESCENDANT: {
                    entitiesToSearch = Entities.descendantsWithoutSelf((Entity)entity);
                    break;
                }
                case ANCESTOR: {
                    entitiesToSearch = Entities.ancestorsWithoutSelf((Entity)entity);
                    break;
                }
                case SIBLING: {
                    entitiesToSearch = entity.getParent().getChildren();
                    entitiesToSearch = Iterables.filter((Iterable)entitiesToSearch, (Predicate)notSelfPredicate);
                    break;
                }
                case CHILD: {
                    entitiesToSearch = entity.getChildren();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected scope " + (Object)((Object)this.scope));
                }
            }
            if (this.componentId == null) {
                if (this.componentIdSupplier == null) {
                    throw new IllegalArgumentException("No component-id or component-id supplier, when resolving entity in scope '" + (Object)((Object)this.scope) + "' wrt " + entity);
                }
                Maybe maybeComponentId = Tasks.resolving(this.componentIdSupplier).as(Object.class).context(this.getExecutionContext()).immediately(immediate).description("Resolving component-id from " + this.componentIdSupplier).getMaybe();
                if (immediate && maybeComponentId.isAbsent()) {
                    return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)"Cannot find component ID", (Maybe)maybeComponentId);
                }
                if (maybeComponentId.get() instanceof BrooklynObject) {
                    if (Iterables.contains((Iterable)entitiesToSearch, (Object)maybeComponentId.get())) {
                        return Maybe.of((Object)((Entity)maybeComponentId.get()));
                    }
                    throw new IllegalStateException("Resolved component " + maybeComponentId.get() + " is not in scope '" + (Object)((Object)this.scope) + "' wrt " + entity);
                }
                desiredComponentId = (String)TypeCoercions.coerce((Object)maybeComponentId.get(), String.class);
                if (Strings.isBlank((CharSequence)desiredComponentId)) {
                    throw new IllegalStateException("component-id blank, from " + this.componentIdSupplier);
                }
            } else {
                desiredComponentId = this.componentId;
            }
            if ((result = Iterables.tryFind((Iterable)entitiesToSearch, (Predicate)EntityPredicates.configEqualTo(BrooklynCampConstants.PLAN_ID, (Object)desiredComponentId))).isPresent()) {
                return Maybe.of((Object)result.get());
            }
            result = Iterables.tryFind((Iterable)entitiesToSearch, (Predicate)EntityPredicates.idEqualTo((String)desiredComponentId));
            if (result.isPresent()) {
                return Maybe.of((Object)result.get());
            }
            return Maybe.absent((Throwable)new NoSuchElementException("No entity matching id " + desiredComponentId + (this.scope == Scope.GLOBAL ? "" : ", in scope " + (Object)((Object)this.scope) + " wrt " + entity + (this.scopeComponent != null ? " (" + this.scopeComponent + " from " + DslComponent.entity() + ")" : ""))));
        }

        private ExecutionContext getExecutionContext() {
            return DslComponent.findExecutionContext(this);
        }
    }
}

