/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.mgmt.persist.DeserializingJcloudsRenamesProvider;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistry;
import org.apache.brooklyn.location.jclouds.JCloudsPropertiesBuilder;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.ContextBuilder;
import org.jclouds.azurecompute.arm.config.AzureComputeRateLimitModule;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.domain.Credentials;
import org.jclouds.encryption.bouncycastle.config.BouncyCastleCryptoModule;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;

public abstract class AbstractComputeServiceRegistry
implements ComputeServiceRegistry,
JcloudsLocationConfig {
    private final Map<Map<?, ?>, ComputeService> cachedComputeServices = new ConcurrentHashMap();

    @Override
    public ComputeService findComputeService(ConfigBag conf, boolean allowReuse) {
        JCloudsPropertiesBuilder propertiesBuilder = new JCloudsPropertiesBuilder(conf).setCommonJcloudsProperties();
        ImmutableSet modules = this.getCommonModules();
        String provider = this.getProviderFromConfig(conf);
        if ("aws-ec2".equals(provider)) {
            propertiesBuilder.setAWSEC2Properties();
        } else if ("azurecompute-arm".equals(provider)) {
            propertiesBuilder.setAzureComputeArmProperties();
            modules = ImmutableSet.builder().addAll(modules).add((Object)new AzureComputeRateLimitModule()).build();
        }
        Properties properties = propertiesBuilder.setCustomJcloudsProperties().setEndpointProperty().build();
        ComputeServiceSupplier computeServiceSupplier = new ComputeServiceSupplier(conf, (Iterable<? extends Module>)modules, properties);
        if (allowReuse) {
            return this.cachedComputeServices.computeIfAbsent(this.makeCacheKey(conf, properties), key -> (ComputeService)computeServiceSupplier.get());
        }
        return (ComputeService)computeServiceSupplier.get();
    }

    private Map<?, ?> makeCacheKey(ConfigBag conf, Properties properties) {
        String provider = this.getProviderFromConfig(conf);
        String identity = (String)Preconditions.checkNotNull((Object)conf.get(CloudLocationConfig.ACCESS_IDENTITY), (Object)"identity must not be null");
        String credential = (String)Preconditions.checkNotNull((Object)conf.get(CloudLocationConfig.ACCESS_CREDENTIAL), (Object)"credential must not be null");
        String endpoint = properties.getProperty("jclouds.endpoint");
        return MutableMap.builder().putAll((Map)properties).put((Object)"provider", (Object)provider).put((Object)"identity", (Object)identity).put((Object)"credential", (Object)credential).putIfNotNull((Object)"endpoint", (Object)endpoint).build().asUnmodifiable();
    }

    protected String getProviderFromConfig(ConfigBag conf) {
        String rawProvider = (String)Preconditions.checkNotNull((Object)conf.get(CLOUD_PROVIDER), (Object)"provider must not be null");
        return DeserializingJcloudsRenamesProvider.INSTANCE.applyJcloudsRenames(rawProvider);
    }

    protected abstract Supplier<Credentials> makeCredentials(ConfigBag var1);

    protected ImmutableSet<Module> getCommonModules() {
        return ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule(), (Object)new BouncyCastleCryptoModule());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class ComputeServiceSupplier
    implements Supplier<ComputeService> {
        private final String provider;
        private final ConfigBag conf;
        private final Iterable<? extends Module> modules;
        private final Properties properties;
        private final Object createComputeServicesMutex = new Object();

        public ComputeServiceSupplier(ConfigBag conf, Iterable<? extends Module> modules, Properties properties) {
            this.provider = AbstractComputeServiceRegistry.this.getProviderFromConfig(conf);
            this.conf = conf;
            this.modules = modules;
            this.properties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ComputeService get() {
            Object object = this.createComputeServicesMutex;
            synchronized (object) {
                ComputeServiceContext computeServiceContext = (ComputeServiceContext)ContextBuilder.newBuilder((String)this.provider).modules(this.modules).credentialsSupplier(AbstractComputeServiceRegistry.this.makeCredentials(this.conf)).overrides(this.properties).build(ComputeServiceContext.class);
                return computeServiceContext.getComputeService();
            }
        }
    }
}

