/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.text;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateProcessor {
    private static final Logger log = LoggerFactory.getLogger(TemplateProcessor.class);

    protected static TemplateModel wrapAsTemplateModel(Object o) throws TemplateModelException {
        if (o instanceof Map) {
            return new DotSplittingTemplateModel((Map)o);
        }
        return ObjectWrapper.DEFAULT_WRAPPER.wrap(o);
    }

    @Deprecated
    public static String processTemplate(String templateFileName, Map<String, ? extends Object> substitutions) {
        return TemplateProcessor.processTemplateFile(templateFileName, substitutions);
    }

    public static String processTemplateFile(String templateFileName, Map<String, ? extends Object> substitutions) {
        String templateContents;
        try {
            templateContents = Files.toString((File)new File(templateFileName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Error loading file " + templateFileName, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        return TemplateProcessor.processTemplateContents(templateContents, substitutions);
    }

    @Deprecated
    public static String processTemplate(String templateFileName, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateFile(templateFileName, driver, extraSubstitutions);
    }

    public static String processTemplateFile(String templateFileName, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        String templateContents;
        try {
            templateContents = Files.toString((File)new File(templateFileName), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Error loading file " + templateFileName, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        return TemplateProcessor.processTemplateContents(templateContents, driver, extraSubstitutions);
    }

    public static String processTemplateContents(String templateContents, EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(templateContents, new EntityAndMapTemplateModel(driver, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, ManagementContext managementContext, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(templateContents, new EntityAndMapTemplateModel(managementContext, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, Location location, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(templateContents, new LocationAndMapTemplateModel((LocationInternal)location, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, EntityInternal entity, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents(templateContents, new EntityAndMapTemplateModel(entity, extraSubstitutions));
    }

    public static String processTemplateContents(String templateContents, Map<String, ? extends Object> substitutions) {
        TemplateHashModel root;
        try {
            root = substitutions != null ? (TemplateHashModel)TemplateProcessor.wrapAsTemplateModel(substitutions) : null;
        }
        catch (TemplateModelException e) {
            throw new IllegalStateException("Unable to set up TemplateHashModel to parse template, given " + substitutions + ": " + (Object)((Object)e), e);
        }
        return TemplateProcessor.processTemplateContents(templateContents, root);
    }

    public static String processTemplateContents(String templateContents, TemplateHashModel substitutions) {
        try {
            Configuration cfg = new Configuration();
            StringTemplateLoader templateLoader = new StringTemplateLoader();
            templateLoader.putTemplate("config", templateContents);
            cfg.setTemplateLoader((TemplateLoader)templateLoader);
            Template template = cfg.getTemplate("config");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(baos);
            template.process((Object)substitutions, (Writer)out);
            ((Writer)out).flush();
            return new String(baos.toByteArray());
        }
        catch (Exception e) {
            log.warn("Error processing template (propagating): " + e, (Throwable)e);
            log.debug("Template which could not be parsed (causing " + e + ") is:" + (Strings.isMultiLine((String)templateContents) ? "\n" + templateContents : templateContents));
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected static final class LocationAndMapTemplateModel
    implements TemplateHashModel {
        protected final LocationInternal location;
        protected final ManagementContext mgmt;
        protected final DotSplittingTemplateModel extraSubstitutionsModel;

        protected LocationAndMapTemplateModel(LocationInternal location, Map<String, ? extends Object> extraSubstitutions) {
            this.location = (LocationInternal)Preconditions.checkNotNull((Object)location, (Object)"location");
            this.mgmt = location.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object result;
            if (this.extraSubstitutionsModel.contains(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.extraSubstitutionsModel.get(key));
            }
            if ("location".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.location);
            }
            if ("config".equals(key)) {
                return new LocationConfigTemplateModel(this.location);
            }
            if ("mgmt".equals(key)) {
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if (this.mgmt != null && (result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build())) != null) {
                log.warn("Deprecated access of global brooklyn.properties value for " + key + "; should be qualified with 'mgmt.'");
                return TemplateProcessor.wrapAsTemplateModel(result);
            }
            if ("javaSysProps".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.getProperties());
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.location + "]";
        }
    }

    protected static final class EntityAndMapTemplateModel
    implements TemplateHashModel {
        protected final EntityInternal entity;
        protected final EntityDriver driver;
        protected final ManagementContext mgmt;
        protected final DotSplittingTemplateModel extraSubstitutionsModel;

        protected EntityAndMapTemplateModel(ManagementContext mgmt, Map<String, ? extends Object> extraSubstitutions) {
            this.entity = null;
            this.driver = null;
            this.mgmt = mgmt;
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        protected EntityAndMapTemplateModel(EntityDriver driver, Map<String, ? extends Object> extraSubstitutions) {
            this.driver = driver;
            this.entity = (EntityInternal)driver.getEntity();
            this.mgmt = this.entity.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        protected EntityAndMapTemplateModel(EntityInternal entity, Map<String, ? extends Object> extraSubstitutions) {
            this.entity = entity;
            this.driver = null;
            this.mgmt = entity.getManagementContext();
            this.extraSubstitutionsModel = new DotSplittingTemplateModel(extraSubstitutions);
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object result;
            if (this.extraSubstitutionsModel.contains(key)) {
                return TemplateProcessor.wrapAsTemplateModel(this.extraSubstitutionsModel.get(key));
            }
            if ("entity".equals(key) && this.entity != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.entity);
            }
            if ("config".equals(key)) {
                if (this.entity != null) {
                    return new EntityConfigTemplateModel(this.entity);
                }
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if ("mgmt".equals(key)) {
                return new MgmtConfigTemplateModel(this.mgmt);
            }
            if ("driver".equals(key) && this.driver != null) {
                return TemplateProcessor.wrapAsTemplateModel(this.driver);
            }
            if ("location".equals(key)) {
                if (this.driver != null && this.driver.getLocation() != null) {
                    return TemplateProcessor.wrapAsTemplateModel(this.driver.getLocation());
                }
                if (this.entity != null) {
                    return TemplateProcessor.wrapAsTemplateModel(Iterables.getOnlyElement((Iterable)this.entity.getLocations()));
                }
            }
            if ("attribute".equals(key)) {
                return new EntityAttributeTemplateModel(this.entity);
            }
            if (this.mgmt != null && (result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build())) != null) {
                log.warn("Deprecated access of global brooklyn.properties value for " + key + "; should be qualified with 'mgmt.'");
                return TemplateProcessor.wrapAsTemplateModel(result);
            }
            if ("javaSysProps".equals(key)) {
                return TemplateProcessor.wrapAsTemplateModel(System.getProperties());
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + (this.entity != null ? this.entity : this.mgmt) + "]";
        }
    }

    protected static final class EntityAttributeTemplateModel
    implements TemplateHashModel {
        protected final EntityInternal entity;

        protected EntityAttributeTemplateModel(EntityInternal entity) {
            this.entity = entity;
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            Object result;
            try {
                result = Entities.submit((Entity)this.entity, DependentConfiguration.attributeWhenReady((Entity)this.entity, Sensors.builder(Object.class, key).persistence(AttributeSensor.SensorPersistenceMode.NONE).build())).get();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (result == null) {
                return null;
            }
            return TemplateProcessor.wrapAsTemplateModel(result);
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity + "]";
        }
    }

    protected static final class LocationConfigTemplateModel
    implements TemplateHashModel {
        protected final LocationInternal location;
        protected final ManagementContext mgmt;

        protected LocationConfigTemplateModel(LocationInternal location) {
            this.location = (LocationInternal)Preconditions.checkNotNull((Object)location, (Object)"location");
            this.mgmt = location.getManagementContext();
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = null;
                result = this.location.getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result == null && this.mgmt != null) {
                    result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                }
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error accessing config '" + key + "'" + (this.location != null ? " on " + this.location : "") + ": " + e, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.location + "]";
        }
    }

    protected static final class MgmtConfigTemplateModel
    implements TemplateHashModel {
        protected final ManagementContext mgmt;

        protected MgmtConfigTemplateModel(ManagementContext mgmt) {
            this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error accessing config '" + key + "': " + e, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.mgmt + "]";
        }
    }

    protected static final class EntityConfigTemplateModel
    implements TemplateHashModel {
        protected final EntityInternal entity;
        protected final ManagementContext mgmt;

        protected EntityConfigTemplateModel(EntityInternal entity) {
            this.entity = (EntityInternal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
            this.mgmt = entity.getManagementContext();
        }

        public boolean isEmpty() {
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                Object result = this.entity.getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                if (result == null) {
                    result = this.mgmt.getConfig().getConfig(((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name(key)).build());
                }
                if (result != null) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error accessing config '" + key + "' on " + this.entity + ": " + e, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity + "]";
        }
    }

    public static final class DotSplittingTemplateModel
    implements TemplateHashModel {
        protected final Map<?, ?> map;

        protected DotSplittingTemplateModel(Map<?, ?> map) {
            this.map = map;
        }

        public boolean isEmpty() {
            return this.map != null && this.map.isEmpty();
        }

        public boolean contains(String key) {
            if (this.map == null) {
                return false;
            }
            if (this.map.containsKey(key)) {
                return true;
            }
            for (Map.Entry<?, ?> entry : this.map.entrySet()) {
                String k = Strings.toString(entry.getKey());
                if (!k.startsWith(key + ".")) continue;
                return true;
            }
            return false;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            if (this.map == null) {
                return null;
            }
            try {
                if (this.map.containsKey(key)) {
                    return TemplateProcessor.wrapAsTemplateModel(this.map.get(key));
                }
                MutableMap result = MutableMap.of();
                for (Map.Entry<?, ?> entry : this.map.entrySet()) {
                    String k = Strings.toString(entry.getKey());
                    if (!k.startsWith(key + ".")) continue;
                    String k2 = Strings.removeFromStart((String)k, (String)(key + "."));
                    result.put(k2, entry.getValue());
                }
                if (!result.isEmpty()) {
                    return TemplateProcessor.wrapAsTemplateModel(result);
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Error accessing config '" + key + "': " + e, e);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.map + "]";
        }
    }
}

