/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompoundTask<T>
extends BasicTask<List<T>>
implements HasTaskChildren {
    private static final Logger log = LoggerFactory.getLogger(CompoundTask.class);
    protected final List<Task<? extends T>> children;
    protected final List<Object> result;

    public CompoundTask(Object ... jobs) {
        this(Arrays.asList(jobs));
    }

    public CompoundTask(Collection<?> jobs) {
        this((Map<String, ?>)MutableMap.of((Object)"tag", (Object)"compound"), jobs);
    }

    public CompoundTask(Map<String, ?> flags, Collection<?> jobs) {
        super(flags);
        this.job = new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return CompoundTask.this.runJobs();
            }
        };
        this.result = new ArrayList<Object>(jobs.size());
        this.children = new ArrayList<Task<? extends T>>(jobs.size());
        for (Object job : jobs) {
            BasicTask subtask;
            if (job instanceof TaskAdaptable) {
                subtask = ((TaskAdaptable)job).asTask();
            } else if (job instanceof Closure) {
                log.warn("Use of groovy.lang.Closure is deprecated, in CompoundTask jobs");
                subtask = new BasicTask((Closure)job);
            } else if (job instanceof Callable) {
                subtask = new BasicTask((Callable)job);
            } else if (job instanceof Runnable) {
                subtask = new BasicTask((Runnable)job);
            } else {
                throw new IllegalArgumentException("Invalid child " + (job == null ? null : job.getClass() + " (" + job + ")") + " passed to compound task; must be Runnable, Callable or Task (Closure support is deprecated)");
            }
            BrooklynTaskTags.addTagDynamically(subtask, "SUB-TASK");
            this.children.add(subtask);
        }
        for (Task t : this.getChildren()) {
            ((TaskInternal)t).markQueued();
        }
    }

    protected abstract List<T> runJobs() throws InterruptedException, ExecutionException;

    protected void submitIfNecessary(TaskAdaptable<?> task) {
        if (!task.asTask().isSubmitted()) {
            if (BasicExecutionContext.getCurrentExecutionContext() == null) {
                throw new IllegalStateException("Compound task (" + task + ") launched from " + this + " missing required execution context");
            }
            BasicExecutionContext.getCurrentExecutionContext().submit(task);
        }
    }

    public List<Task<? extends T>> getChildrenTyped() {
        return this.children;
    }

    public List<Task<?>> getChildren() {
        return this.getChildrenTyped();
    }

    @Override
    protected boolean doCancel(TaskInternal.TaskCancellationMode mode) {
        boolean result = false;
        if (mode.isAllowedToInterruptDependentSubmittedTasks()) {
            for (Task t : this.getChildren()) {
                if (t.isDone()) continue;
                result = ((TaskInternal)t).cancel(mode) || result;
            }
        }
        result = super.doCancel(mode) || result;
        return result;
    }
}

