/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import groovy.lang.Closure;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.task.ListenableForwardingFuture;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.StackTraceSimplifier;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTask<T>
implements TaskInternal<T> {
    private static final Logger log = LoggerFactory.getLogger(BasicTask.class);
    private String id = Identifiers.makeRandomId((int)8);
    protected Callable<T> job;
    public final String displayName;
    public final String description;
    protected final Set<Object> tags = Sets.newConcurrentHashSet();
    protected Task<?> proxyTargetTask = null;
    protected String blockingDetails = null;
    protected Task<?> blockingTask = null;
    Object extraStatusText = null;
    protected final ExecutionList listeners = new ExecutionList();
    protected long queuedTimeUtc = -1L;
    protected long submitTimeUtc = -1L;
    protected long startTimeUtc = -1L;
    protected long endTimeUtc = -1L;
    protected Maybe<Task<?>> submittedByTask;
    protected volatile Thread thread = null;
    protected volatile boolean cancelled = false;
    protected volatile Future<T> internalFuture = null;
    public static final TaskFinalizer WARN_IF_NOT_RUN = new TaskFinalizer(){

        @Override
        public void onTaskFinalization(Task<?> t) {
            if (!Tasks.isAncestorCancelled(t) && !t.isSubmitted()) {
                log.warn(t + " was never submitted; did the code create it and forget to run it? ('cancel' the task to suppress this message)");
                log.debug("Detail of unsubmitted task " + t + ":\n" + t.getStatusDetail(true));
                return;
            }
            if (!t.isDone()) {
                log.warn("Task " + t + " is being finalized before completion");
                return;
            }
        }
    };
    public static final TaskFinalizer NO_OP = new TaskFinalizer(){

        @Override
        public void onTaskFinalization(Task<?> t) {
        }
    };

    @Deprecated
    protected BasicTask() {
        this(Collections.emptyMap());
    }

    protected BasicTask(Map<?, ?> flags) {
        this(flags, (Callable)null);
    }

    public BasicTask(Callable<T> job) {
        this(Collections.emptyMap(), job);
    }

    public BasicTask(Map<?, ?> flags, Callable<T> job) {
        Object ftags;
        this.job = job;
        if (flags.containsKey("tag")) {
            this.tags.add(flags.remove("tag"));
        }
        if ((ftags = flags.remove("tags")) != null) {
            if (ftags instanceof Iterable) {
                Iterables.addAll(this.tags, (Iterable)((Iterable)ftags));
            } else {
                log.info("deprecated use of non-collection argument for 'tags' (" + ftags + ") in " + this, new Throwable("trace of discouraged use of non-colleciton tags argument"));
                this.tags.add(ftags);
            }
        }
        this.description = JavaGroovyEquivalents.elvisString(flags.remove("description"), (Object)"");
        String d = JavaGroovyEquivalents.asString(flags.remove("displayName"));
        this.displayName = d == null ? "" : d;
    }

    public BasicTask(Runnable job) {
        this(JavaGroovyEquivalents.toCallable((Runnable)job));
    }

    public BasicTask(Map<?, ?> flags, Runnable job) {
        this(flags, JavaGroovyEquivalents.toCallable((Runnable)job));
    }

    @Deprecated
    public BasicTask(Closure<T> job) {
        this(GroovyJavaMethods.callableFromClosure(job));
    }

    @Deprecated
    public BasicTask(Map<?, ?> flags, Closure<T> job) {
        this(flags, GroovyJavaMethods.callableFromClosure(job));
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task) {
            return ((Task)obj).getId().equals(this.getId());
        }
        return false;
    }

    public String toString() {
        return "Task[" + (Strings.isNonEmpty((CharSequence)this.displayName) ? this.displayName : this.job + (this.tags != null && !this.tags.isEmpty() ? ";" + this.tags : "")) + "]@" + this.getId();
    }

    public Task<T> asTask() {
        return this;
    }

    @Override
    public synchronized void initInternalFuture(ListenableFuture<T> result) {
        if (this.internalFuture != null) {
            throw new IllegalStateException("task " + this + " is being given a result twice");
        }
        this.internalFuture = result;
        this.notifyAll();
    }

    public Set<Object> getTags() {
        return Collections.unmodifiableSet(new LinkedHashSet<Object>(this.tags));
    }

    @Override
    public long getQueuedTimeUtc() {
        return this.queuedTimeUtc;
    }

    public long getSubmitTimeUtc() {
        return this.submitTimeUtc;
    }

    public long getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public long getEndTimeUtc() {
        return this.endTimeUtc;
    }

    @Override
    public Future<T> getInternalFuture() {
        return this.internalFuture;
    }

    public Task<?> getSubmittedByTask() {
        if (this.submittedByTask == null) {
            return null;
        }
        return (Task)this.submittedByTask.orNull();
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public boolean isQueued() {
        return this.queuedTimeUtc >= 0L;
    }

    @Override
    public boolean isQueuedOrSubmitted() {
        return this.isQueued() || this.isSubmitted();
    }

    @Override
    public boolean isQueuedAndNotSubmitted() {
        return this.isQueued() && !this.isSubmitted();
    }

    public boolean isSubmitted() {
        return this.submitTimeUtc >= 0L;
    }

    public boolean isBegun() {
        return this.startTimeUtc >= 0L;
    }

    @Override
    public void markQueued() {
        if (this.queuedTimeUtc < 0L) {
            this.queuedTimeUtc = System.currentTimeMillis();
        }
    }

    @Override
    public final synchronized boolean cancel() {
        return this.cancel(true);
    }

    @Beta
    public synchronized boolean uncancel() {
        boolean wasCancelled = this.cancelled;
        this.cancelled = false;
        return wasCancelled;
    }

    public final synchronized boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel(mayInterruptIfRunning ? TaskInternal.TaskCancellationMode.INTERRUPT_TASK_AND_DEPENDENT_SUBMITTED_TASKS : TaskInternal.TaskCancellationMode.DO_NOT_INTERRUPT);
    }

    @Override
    @Beta
    public synchronized boolean cancel(TaskInternal.TaskCancellationMode mode) {
        if (this.isDone()) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("BT cancelling " + this + " mode " + mode + ", from thread " + Thread.currentThread());
        }
        this.cancelled = true;
        this.doCancel(mode);
        this.notifyAll();
        return true;
    }

    protected boolean doCancel(TaskInternal.TaskCancellationMode mode) {
        if (this.internalFuture != null) {
            if (this.internalFuture instanceof ListenableForwardingFuture) {
                return ((ListenableForwardingFuture)((Object)this.internalFuture)).cancel(mode);
            }
            return this.internalFuture.cancel(mode.isAllowedToInterruptTask());
        }
        return true;
    }

    public boolean isCancelled() {
        return this.cancelled || this.internalFuture != null && this.internalFuture.isCancelled();
    }

    public boolean isDone() {
        return this.cancelled || this.internalFuture != null && this.internalFuture.isDone() || this.endTimeUtc > 0L;
    }

    public boolean isError() {
        if (!this.isDone()) {
            return false;
        }
        if (this.isCancelled()) {
            return true;
        }
        try {
            this.get();
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            if (!this.isDone()) {
                Tasks.setBlockingTask(this);
            }
            this.blockUntilStarted();
            T t = this.internalFuture.get();
            return t;
        }
        finally {
            Tasks.resetBlockingTask();
        }
    }

    public T getUnchecked() {
        try {
            return this.get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public synchronized void blockUntilStarted() {
        this.blockUntilStarted(null);
    }

    @Override
    public synchronized boolean blockUntilStarted(Duration timeout) {
        Long endTime;
        Long l = endTime = timeout == null ? null : Long.valueOf(System.currentTimeMillis() + timeout.toMillisecondsRoundingUp());
        do {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.internalFuture != null) continue;
            try {
                if (timeout == null) {
                    this.wait();
                    continue;
                }
                long remaining = endTime - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.wait(remaining);
                    continue;
                }
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        } while (this.internalFuture == null);
        return true;
    }

    public void blockUntilEnded() {
        this.blockUntilEnded(null);
    }

    public boolean blockUntilEnded(Duration timeout) {
        Long endTime = timeout == null ? null : Long.valueOf(System.currentTimeMillis() + timeout.toMillisecondsRoundingUp());
        try {
            boolean started = this.blockUntilStarted(timeout);
            if (!started) {
                return false;
            }
            if (timeout == null) {
                this.internalFuture.get();
            } else {
                long remaining = endTime - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.internalFuture.get(remaining, TimeUnit.MILLISECONDS);
                }
            }
            return this.isDone();
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            if (!(t instanceof TimeoutException) && log.isDebugEnabled()) {
                log.debug("call from " + Thread.currentThread() + ", blocking until '" + this + "' finishes, ended with error: " + t);
            }
            return this.isDone();
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(new Duration(timeout, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        Long remaining;
        Long end;
        long start = System.currentTimeMillis();
        Long l = end = duration == null ? null : Long.valueOf(start + duration.toMillisecondsRoundingUp());
        while (end == null || end > System.currentTimeMillis()) {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.internalFuture == null) {
                BasicTask basicTask = this;
                synchronized (basicTask) {
                    long remaining2 = end - System.currentTimeMillis();
                    if (this.internalFuture == null && remaining2 > 0L) {
                        this.wait(remaining2);
                    }
                }
            }
            if (this.internalFuture == null) continue;
        }
        Long l2 = remaining = end == null ? null : Long.valueOf(end - System.currentTimeMillis());
        if (this.isDone()) {
            if (this.internalFuture == null) {
                assert (this.cancelled) : "task=" + this + "; endTimeUtc=" + this.endTimeUtc + "; cancelled=" + this.cancelled + "; isDone=true; null internal future";
                throw new CancellationException();
            }
            if (remaining == null) {
                return this.internalFuture.get();
            }
            return this.internalFuture.get(Math.max(remaining, 1000L), TimeUnit.MILLISECONDS);
        }
        if (remaining == null) {
            return this.internalFuture.get();
        }
        if (remaining > 0L) {
            return this.internalFuture.get(remaining, TimeUnit.MILLISECONDS);
        }
        throw new TimeoutException();
    }

    public T getUnchecked(Duration duration) {
        try {
            return this.get(duration);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String getStatusSummary() {
        return this.getStatusString(0);
    }

    public String getStatusDetail(boolean multiline) {
        return this.getStatusString(multiline ? 2 : 1);
    }

    protected String getStatusString(int verbosity) {
        String rv;
        if (this.submitTimeUtc <= 0L) {
            rv = "Not submitted";
        } else if (!this.isCancelled() && this.startTimeUtc <= 0L) {
            rv = "Submitted for execution";
            if (verbosity > 0) {
                long elapsed = System.currentTimeMillis() - this.submitTimeUtc;
                rv = rv + " " + Time.makeTimeStringRoundedSince((long)elapsed) + " ago";
            }
            if (verbosity >= 2 && this.getExtraStatusText() != null) {
                rv = rv + "\n\n" + this.getExtraStatusText();
            }
        } else if (this.isDone()) {
            long elapsed = this.endTimeUtc - this.submitTimeUtc;
            String duration = Time.makeTimeStringRounded((long)elapsed);
            if (this.isCancelled()) {
                rv = "Cancelled";
                if (verbosity >= 1) {
                    rv = rv + " after " + duration;
                }
                if (verbosity >= 2 && this.getExtraStatusText() != null) {
                    rv = rv + "\n\n" + this.getExtraStatusText();
                }
            } else if (this.isError()) {
                rv = "Failed";
                if (verbosity >= 1) {
                    rv = rv + " after " + duration;
                    Throwable error = Tasks.getError(this);
                    if (verbosity >= 2 && this.getExtraStatusText() != null) {
                        rv = rv + "\n\n" + this.getExtraStatusText();
                    }
                    while (error instanceof ExecutionException) {
                        error = error.getCause();
                    }
                    String errorMessage = Exceptions.collapseText((Throwable)error);
                    if (verbosity == 1) {
                        rv = rv + ": " + BasicTask.abbreviate(errorMessage);
                    }
                    if (verbosity >= 2) {
                        rv = rv + ": " + errorMessage;
                        StringWriter sw = new StringWriter();
                        error.printStackTrace(new PrintWriter(sw));
                        rv = rv + "\n\n" + sw.getBuffer();
                    }
                }
            } else {
                rv = "Completed";
                if (verbosity >= 1) {
                    if (verbosity == 1) {
                        try {
                            T v = this.get();
                            rv = rv + ", " + (v == null ? "no return value (null)" : "result: " + BasicTask.abbreviate(v.toString()));
                        }
                        catch (Exception e) {
                            rv = rv + ", but error accessing result [" + e + "]";
                        }
                    } else {
                        rv = rv + " after " + duration;
                        try {
                            T v = this.get();
                            rv = rv + "\n\n" + (v == null ? "No return value (null)" : "Result: " + v);
                        }
                        catch (Exception e) {
                            rv = rv + " at first\nError accessing result [" + e + "]";
                        }
                        if (verbosity >= 2 && this.getExtraStatusText() != null) {
                            rv = rv + "\n\n" + this.getExtraStatusText();
                        }
                    }
                }
            }
        } else {
            rv = this.getActiveTaskStatusString(verbosity);
        }
        return rv;
    }

    private static String abbreviate(String s) {
        if ((s = Strings.getFirstLine((String)s)).length() > 255) {
            s = s.substring(0, 252) + "...";
        }
        return s;
    }

    protected String getActiveTaskStatusString(int verbosity) {
        String rv = "";
        Thread t = this.getThread();
        if (t == null) {
            if (this.isDone()) {
                return this.getStatusString(verbosity);
            }
            return "Sleeping";
        }
        ThreadInfo ti = ManagementFactory.getThreadMXBean().getThreadInfo(t.getId(), verbosity <= 0 ? 0 : (verbosity == 1 ? 1 : Integer.MAX_VALUE));
        if (this.getThread() == null) {
            return this.getStatusString(verbosity);
        }
        if (verbosity >= 1 && Strings.isNonBlank((CharSequence)this.blockingDetails)) {
            if (verbosity == 1) {
                return this.blockingDetails;
            }
            rv = this.blockingDetails + "\n\n";
        }
        if (verbosity >= 1 && this.blockingTask != null) {
            if (verbosity == 1) {
                return "Waiting on " + this.blockingTask;
            }
            rv = "Waiting on " + this.blockingTask + "\n\n";
        }
        if (verbosity >= 2) {
            if (this.getExtraStatusText() != null) {
                rv = rv + this.getExtraStatusText() + "\n\n";
            }
            rv = rv + "" + this.toString() + "\n";
            if (this.submittedByTask != null) {
                rv = rv + "Submitted by " + this.submittedByTask + "\n";
            }
            if (this instanceof HasTaskChildren) {
                try {
                    Iterable childrenTasks = ((HasTaskChildren)this).getChildren();
                    if (childrenTasks.iterator().hasNext()) {
                        rv = rv + "Children:\n";
                        for (Task child : childrenTasks) {
                            rv = rv + "  " + child + ": " + child.getStatusDetail(false) + "\n";
                        }
                    }
                }
                catch (ConcurrentModificationException exc) {
                    rv = rv + "  (children not available - currently being modified)\n";
                }
            }
            rv = rv + "\n";
        }
        LockInfo lock = ti.getLockInfo();
        rv = rv + "In progress";
        if (verbosity >= 1) {
            if (lock == null && ti.getThreadState() == Thread.State.RUNNABLE) {
                if (ti.isSuspended()) {
                    rv = rv + ", thread suspended";
                } else if (verbosity >= 2) {
                    rv = rv + " (" + (Object)((Object)ti.getThreadState()) + ")";
                }
            } else {
                rv = rv + ", thread waiting ";
                rv = ti.getThreadState() == Thread.State.BLOCKED ? rv + "(mutex) on " + this.lookup(lock) : (ti.getThreadState() == Thread.State.WAITING ? rv + "(notify) on " + this.lookup(lock) : (ti.getThreadState() == Thread.State.TIMED_WAITING ? rv + "(timed) on " + this.lookup(lock) : "(" + (Object)((Object)ti.getThreadState()) + ") on " + this.lookup(lock)));
            }
        }
        if (verbosity >= 2) {
            StackTraceElement[] st = ti.getStackTrace();
            if ((st = StackTraceSimplifier.cleanStackTrace((StackTraceElement[])st)) != null && st.length > 0) {
                rv = rv + "\nAt: " + st[0];
            }
            for (int ii = 1; ii < st.length; ++ii) {
                rv = rv + "\n    " + st[ii];
            }
        }
        return rv;
    }

    protected String lookup(LockInfo info) {
        return info != null ? "" + info : "unknown (sleep)";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String setBlockingDetails(String blockingDetails) {
        String old = this.blockingDetails;
        this.blockingDetails = blockingDetails;
        return old;
    }

    @Override
    public Task<?> setBlockingTask(Task<?> blockingTask) {
        Task<?> old = this.blockingTask;
        this.blockingTask = blockingTask;
        return old;
    }

    @Override
    public void resetBlockingDetails() {
        this.blockingDetails = null;
    }

    @Override
    public void resetBlockingTask() {
        this.blockingTask = null;
    }

    @Override
    public String getBlockingDetails() {
        return this.blockingDetails;
    }

    @Override
    public Task<?> getBlockingTask() {
        return this.blockingTask;
    }

    @Override
    public void setExtraStatusText(Object extraStatus) {
        this.extraStatusText = extraStatus;
    }

    @Override
    public Object getExtraStatusText() {
        return this.extraStatusText;
    }

    public void ignoreIfNotRun() {
        this.setFinalizer(NO_OP);
    }

    public void setFinalizer(TaskFinalizer f) {
        TaskFinalizer finalizer = Tasks.tag(this, TaskFinalizer.class, false);
        if (finalizer != null && finalizer != f) {
            throw new IllegalStateException("Cannot apply multiple finalizers");
        }
        if (this.isDone()) {
            throw new IllegalStateException("Finalizer cannot be set on task " + this + " after it is finished");
        }
        this.tags.add(f);
    }

    protected void finalize() throws Throwable {
        TaskFinalizer finalizer = Tasks.tag(this, TaskFinalizer.class, false);
        if (finalizer == null) {
            finalizer = WARN_IF_NOT_RUN;
        }
        finalizer.onTaskFinalization(this);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.listeners.add(listener, (Executor)new SubmissionErrorCatchingExecutor(executor));
    }

    @Override
    public void runListeners() {
        this.listeners.execute();
    }

    @Override
    public void setEndTimeUtc(long val) {
        this.endTimeUtc = val;
    }

    @Override
    public void setThread(Thread thread) {
        this.thread = thread;
    }

    @Override
    public Callable<T> getJob() {
        return this.job;
    }

    @Override
    public void setJob(Callable<T> job) {
        this.job = job;
    }

    @Override
    public ExecutionList getListeners() {
        return this.listeners;
    }

    @Override
    public void setSubmitTimeUtc(long val) {
        this.submitTimeUtc = val;
    }

    private static <T> Task<T> newGoneTaskFor(Task<?> task) {
        Task t = Tasks.builder().dynamic(false).displayName(task.getDisplayName()).description("Details of the original task " + task + " have been forgotten.").body(Callables.returning(null)).build();
        ((BasicTask)t).ignoreIfNotRun();
        return t;
    }

    @Override
    public void setSubmittedByTask(Task<?> task) {
        this.submittedByTask = Maybe.softThen(task, (Maybe)Maybe.of(BasicTask.newGoneTaskFor(task)));
    }

    @Override
    public Set<Object> getMutableTags() {
        return this.tags;
    }

    @Override
    public void setStartTimeUtc(long val) {
        this.startTimeUtc = val;
    }

    @Override
    public void applyTagModifier(Function<Set<Object>, Void> modifier) {
        modifier.apply(this.tags);
    }

    @Override
    public Task<?> getProxyTarget() {
        return this.proxyTargetTask;
    }

    public static class SubmissionErrorCatchingExecutor
    implements Executor {
        final Executor target;

        public SubmissionErrorCatchingExecutor(Executor target) {
            this.target = target;
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown()) {
                log.debug("Skipping execution of task callback hook " + command + " because executor is shutdown.");
                return;
            }
            try {
                this.target.execute(command);
            }
            catch (Exception e) {
                if (this.isShutdown()) {
                    log.debug("Ignoring failed execution of task callback hook " + command + " because executor is shutdown.");
                }
                log.warn("Execution of task callback hook " + command + " failed: " + e, (Throwable)e);
            }
        }

        protected boolean isShutdown() {
            return this.target instanceof ExecutorService && ((ExecutorService)this.target).isShutdown();
        }
    }

    public static interface TaskFinalizer {
        public void onTaskFinalization(Task<?> var1);
    }
}

