/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.javalang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.util.text.Strings;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionScanner {
    private static final Logger log = LoggerFactory.getLogger(ReflectionScanner.class);
    protected final ClassLoader[] classLoaders;
    protected final Reflections reflections;

    public ReflectionScanner(Iterable<URL> urlsToScan, String optionalPrefix, ClassLoader ... classLoaders) {
        this(urlsToScan, optionalPrefix, (Predicate<String>)(Strings.isNonEmpty((CharSequence)optionalPrefix) ? new FilterBuilder.Include(FilterBuilder.prefix((String)optionalPrefix)) : null), classLoaders);
    }

    public ReflectionScanner(final Iterable<URL> urlsToScan, final String optionalPrefix, final Predicate<String> filter, final ClassLoader ... classLoaders) {
        if (Reflections.log == null) {
            Reflections.log = log;
        }
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder(){
            {
                if (urlsToScan != null) {
                    this.setUrls((Collection)ImmutableSet.copyOf((Iterable)urlsToScan));
                } else if (classLoaders.length > 0 && classLoaders[0] != null) {
                    this.setUrls(ClasspathHelper.forPackage((String)(Strings.isNonEmpty((CharSequence)optionalPrefix) ? optionalPrefix : ""), (ClassLoader[])ReflectionScanner.asClassLoaderVarArgs(classLoaders[0])));
                }
                if (filter != null) {
                    this.filterInputsBy(filter);
                }
                TypeAnnotationsScanner typeScanner = new TypeAnnotationsScanner();
                if (filter != null) {
                    typeScanner = typeScanner.filterResultsBy(filter);
                }
                SubTypesScanner subTypeScanner = new SubTypesScanner();
                if (filter != null) {
                    subTypeScanner = subTypeScanner.filterResultsBy(filter);
                }
                this.setScanners(new Scanner[]{typeScanner, subTypeScanner});
                for (ClassLoader cl : classLoaders) {
                    if (cl == null) continue;
                    this.addClassLoader(cl);
                }
            }
        });
        this.classLoaders = (ClassLoader[])Iterables.toArray((Iterable)Iterables.filter(Arrays.asList(classLoaders), (Predicate)Predicates.notNull()), ClassLoader.class);
    }

    private static ClassLoader[] asClassLoaderVarArgs(ClassLoader classLoaderToSearch) {
        ClassLoader[] classLoaderArray;
        if (classLoaderToSearch == null) {
            classLoaderArray = new ClassLoader[]{};
        } else {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = classLoaderToSearch;
        }
        return classLoaderArray;
    }

    public Store getStore() {
        return this.reflections.getStore();
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set subTypes = this.getStore().getSubTypesOf(type.getName());
        return ImmutableSet.copyOf(this.forNames(subTypes, "sub-type of " + type));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Set annotatedWith = this.getStore().getTypesAnnotatedWith(annotation.getName());
        return ImmutableSet.copyOf(this.forNames(annotatedWith, "annotated " + annotation.getName()));
    }

    protected <T> List<Class<? extends T>> forNames(Set<String> classNames, String context) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classNames) {
            try {
                Class<?> clazz = this.loadClass(className);
                if (clazz != null) {
                    result.add(clazz);
                    continue;
                }
                log.warn("Unable to instantiate '" + className + "' (" + context + ")");
            }
            catch (Throwable e) {
                log.warn("Unable to instantiate '" + className + "' (" + context + "): " + e);
            }
        }
        return result;
    }

    protected Class<?> loadClass(String className) {
        return ReflectionUtils.forName((String)className, (ClassLoader[])this.classLoaders);
    }
}

