/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.server;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.catalog.CatalogLoadMode;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynServerConfig {
    private static final Logger log = LoggerFactory.getLogger(BrooklynServerConfig.class);
    public static final ConfigKey<String> MGMT_BASE_DIR = ConfigKeys.newStringConfigKey("brooklyn.base.dir", "Directory for reading and writing all brooklyn server data", Os.fromHome((String)".brooklyn"));
    @Deprecated
    public static final ConfigKey<String> BROOKLYN_DATA_DIR = ConfigKeys.newStringConfigKey("brooklyn.datadir", "Directory for writing all brooklyn data");
    public static final ConfigKey<String> PERSISTENCE_DIR = ConfigKeys.newStringConfigKey("brooklyn.persistence.dir", "Directory or container name for writing persisted state");
    public static final ConfigKey<String> PERSISTENCE_LOCATION_SPEC = ConfigKeys.newStringConfigKey("brooklyn.persistence.location.spec", "Optional location spec string for an object store (e.g. jclouds:swift:URL) where persisted state should be kept; if blank or not supplied, the file system is used");
    public static final ConfigKey<String> PERSISTENCE_BACKUPS_DIR = ConfigKeys.newStringConfigKey("brooklyn.persistence.backups.dir", "Directory or container name for writing backups of persisted state; defaults to 'backups' inside the default persistence directory");
    public static final ConfigKey<String> PERSISTENCE_BACKUPS_LOCATION_SPEC = ConfigKeys.newStringConfigKey("brooklyn.persistence.backups.location.spec", "Location spec string for an object store (e.g. jclouds:swift:URL) where backups of persisted state should be kept; defaults to the local file system");
    public static final ConfigKey<Boolean> PERSISTENCE_BACKUPS_REQUIRED_ON_PROMOTION = ConfigKeys.newBooleanConfigKey("brooklyn.persistence.backups.required.promotion", "Whether a backup should be made of the persisted state from the persistence location to the backup location on node promotion, before any writes from this node", true);
    public static final ConfigKey<Boolean> PERSISTENCE_BACKUPS_REQUIRED_ON_DEMOTION = ConfigKeys.newBooleanConfigKey("brooklyn.persistence.backups.required.promotion", "Whether a backup of in-memory state should be made to the backup persistence location on node demotion, in case other nodes might write conflicting state", true);
    @Deprecated
    public static final ConfigKey<Boolean> PERSISTENCE_BACKUPS_REQUIRED = ConfigKeys.newBooleanConfigKey("brooklyn.persistence.backups.required", "Whether a backup should always be made of the persistence directory; if true, it will fail if this operation is not permitted (e.g. jclouds-based cloud object stores); if false, the persistence store will be overwritten with changes (but files not removed if they are unreadable); if null or not set, the legacy beahviour of creating backups where possible (e.g. file system) is currently used; this key is DEPRECATED in favor of promotion and demotion specific flags now defaulting to true");
    public static final ConfigKey<String> BROOKLYN_CATALOG_URL = ConfigKeys.newStringConfigKey("brooklyn.catalog.url", "The URL of a custom catalog.bom to load");
    @Deprecated
    public static final ConfigKey<CatalogLoadMode> CATALOG_LOAD_MODE = ConfigKeys.newConfigKey(CatalogLoadMode.class, "brooklyn.catalog.mode", "The mode the management context should use to load the catalog when first starting");
    public static final String MANAGEMENT_NODE_ID_PROPERTY = "brooklyn.mgmt.node.id";
    public static final ConfigKey<Boolean> USE_OSGI = ConfigKeys.newBooleanConfigKey("brooklyn.osgi.enabled", "Whether OSGi is enabled, defaulting to true", true);
    public static final ConfigKey<String> OSGI_CACHE_DIR = ConfigKeys.newStringConfigKey("brooklyn.osgi.cache.dir", "Directory to use for OSGi cache, potentially including Freemarker template variables ${" + MGMT_BASE_DIR.getName() + "} (which is the default for relative paths), ${" + Os.TmpDirFinder.BROOKLYN_OS_TMPDIR_PROPERTY + "} if it should be in the tmp dir space,  and ${" + "brooklyn.mgmt.node.id" + "} to include the management node ID (recommended if running multiple OSGi paths)", "osgi/cache/${brooklyn.mgmt.node.id}/");
    public static final ConfigKey<Boolean> OSGI_CACHE_CLEAN = ConfigKeys.newBooleanConfigKey("brooklyn.osgi.cache.clean", "Whether to delete the OSGi directory before and after use; if unset, it will delete if the node ID forms part of the cache dir path (which by default it does) to avoid file leaks");

    public static String getMgmtBaseDir(ManagementContext mgmt) {
        return BrooklynServerPaths.getMgmtBaseDir(mgmt);
    }

    public static String getMgmtBaseDir(StringConfigMap brooklynProperties) {
        return BrooklynServerPaths.getMgmtBaseDir(brooklynProperties);
    }

    public static String getMgmtBaseDir(Map<String, ?> brooklynProperties) {
        return BrooklynServerPaths.getMgmtBaseDir(brooklynProperties);
    }

    @Deprecated
    public static String getPersistenceDir(ManagementContext mgmt) {
        return BrooklynServerConfig.getPersistenceDir(mgmt.getConfig());
    }

    @Deprecated
    public static String getPersistenceDir(StringConfigMap brooklynProperties) {
        return BrooklynServerConfig.resolvePersistencePath(null, brooklynProperties, null);
    }

    @Deprecated
    public static String resolvePersistencePath(String optionalSuppliedValue, StringConfigMap brooklynProperties, String optionalObjectStoreLocationSpec) {
        return BrooklynServerPaths.newMainPersistencePathResolver(brooklynProperties).location(optionalObjectStoreLocationSpec).dir(optionalSuppliedValue).resolve();
    }

    @Deprecated
    public static File getBrooklynWebTmpDir(ManagementContext mgmt) {
        return BrooklynServerPaths.getBrooklynWebTmpDir(mgmt);
    }

    public static Maybe<URI> getBrooklynWebUri(ManagementContext mgmt) {
        return mgmt.getManagementNodeUri();
    }
}

