/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.password;

import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.AddSensor;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.Identifiers;

public class CreatePasswordSensor
extends AddSensor<String> {
    public static final ConfigKey<Integer> PASSWORD_LENGTH = ConfigKeys.newIntegerConfigKey("password.length", "The length of the password to be created", 12);
    public static final ConfigKey<String> ACCEPTABLE_CHARS = ConfigKeys.newStringConfigKey("password.chars", "The characters allowed in password");
    private Integer passwordLength;
    private String acceptableChars;

    public CreatePasswordSensor(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public CreatePasswordSensor(ConfigBag params) {
        super(params);
        this.passwordLength = params.get(PASSWORD_LENGTH);
        this.acceptableChars = params.get(ACCEPTABLE_CHARS);
    }

    @Override
    public void apply(EntityLocal entity) {
        super.apply(entity);
        String password = this.acceptableChars == null ? Identifiers.makeRandomPassword((int)this.passwordLength) : Identifiers.makeRandomPassword((int)this.passwordLength, (String[])new String[]{this.acceptableChars});
        entity.sensors().set(this.sensor, (Object)password);
    }
}

