/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.annotations.Beta;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.MementoCopyMode;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.ha.ManagementPlaneSyncRecordPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.LocationWithObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.RetryingMementoSerializer;
import org.apache.brooklyn.core.mgmt.persist.XmlMementoSerializer;
import org.apache.brooklyn.core.mgmt.rebind.PersistenceExceptionHandlerImpl;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformer;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformerLoader;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynPersistenceUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynPersistenceUtils.class);
    @Beta
    public static final List<BrooklynObjectType> STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER = ImmutableList.of((Object)BrooklynObjectType.ENTITY, (Object)BrooklynObjectType.LOCATION, (Object)BrooklynObjectType.POLICY, (Object)BrooklynObjectType.ENRICHER, (Object)BrooklynObjectType.FEED, (Object)BrooklynObjectType.CATALOG_ITEM, (Object)BrooklynObjectType.MANAGED_BUNDLE);

    public static PersistenceObjectStore newPersistenceObjectStore(ManagementContext managementContext, String locationSpec, String locationContainer) {
        return BrooklynPersistenceUtils.newPersistenceObjectStore(managementContext, locationSpec, locationContainer, PersistMode.AUTO, HighAvailabilityMode.STANDBY);
    }

    public static PersistenceObjectStore newPersistenceObjectStore(ManagementContext managementContext, String locationSpecString, String locationContainer, PersistMode persistMode, HighAvailabilityMode highAvailabilityMode) {
        locationContainer = BrooklynServerPaths.newMainPersistencePathResolver(managementContext).location(locationSpecString).dir(locationContainer).resolve();
        LocationSpec locationSpec = Strings.isBlank((CharSequence)locationSpecString) ? LocationSpec.create(LocalhostMachineProvisioningLocation.class) : (LocationSpec)managementContext.getLocationRegistry().getLocationSpec(locationSpecString).get();
        Location location = managementContext.getLocationManager().createLocation((LocationSpec)locationSpec.configure(LocalLocationManager.CREATE_UNMANAGED, (Object)true));
        if (!(location instanceof LocationWithObjectStore)) {
            throw new IllegalArgumentException("Destination location " + location + " does not offer a persistent store");
        }
        PersistenceObjectStore destinationObjectStore = ((LocationWithObjectStore)location).newPersistenceObjectStore(locationContainer);
        destinationObjectStore.injectManagementContext(managementContext);
        destinationObjectStore.prepareForSharedUse(persistMode, highAvailabilityMode);
        return destinationObjectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMemento(ManagementContext managementContext, BrooklynMementoRawData memento, PersistenceObjectStore destinationObjectStore) {
        BrooklynMementoPersisterToObjectStore persister = new BrooklynMementoPersisterToObjectStore(destinationObjectStore, managementContext);
        try {
            PersistenceExceptionHandler exceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
            persister.enableWriteAccess();
            persister.checkpoint(memento, exceptionHandler);
        }
        finally {
            persister.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeManagerMemento(ManagementContext managementContext, ManagementPlaneSyncRecord optionalPlaneRecord, PersistenceObjectStore destinationObjectStore) {
        if (optionalPlaneRecord != null) {
            ManagementPlaneSyncRecordPersisterToObjectStore managementPersister = new ManagementPlaneSyncRecordPersisterToObjectStore(managementContext, destinationObjectStore, managementContext.getCatalogClassLoader());
            try {
                managementPersister.checkpoint(optionalPlaneRecord);
            }
            finally {
                managementPersister.stop();
            }
        }
    }

    public static CompoundTransformer loadTransformer(ResourceUtils resources, String transformationsFileUrl) {
        if (Strings.isBlank((CharSequence)transformationsFileUrl)) {
            return CompoundTransformer.NOOP;
        }
        String contents = resources.getResourceAsString(transformationsFileUrl);
        return CompoundTransformerLoader.load(contents);
    }

    public static Memento newObjectMemento(BrooklynObject instance) {
        return ((BrooklynObjectInternal)instance).getRebindSupport().getMemento();
    }

    public static BrooklynMementoRawData newStateMemento(ManagementContext mgmt, MementoCopyMode source) {
        switch (source) {
            case LOCAL: {
                return BrooklynPersistenceUtils.newStateMementoFromLocal(mgmt);
            }
            case REMOTE: {
                return mgmt.getRebindManager().retrieveMementoRawData();
            }
            case AUTO: {
                throw new IllegalStateException("Copy mode AUTO not supported here");
            }
        }
        throw new IllegalStateException("Should not come here, unknown mode " + source);
    }

    public static ManagementPlaneSyncRecord newManagerMemento(ManagementContext mgmt, MementoCopyMode source) {
        switch (source) {
            case LOCAL: {
                return mgmt.getHighAvailabilityManager().getLastManagementPlaneSyncRecord();
            }
            case REMOTE: {
                return mgmt.getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
            }
            case AUTO: {
                throw new IllegalStateException("Copy mode AUTO not supported here");
            }
        }
        throw new IllegalStateException("Should not come here, unknown mode " + source);
    }

    private static BrooklynMementoRawData newStateMementoFromLocal(ManagementContext mgmt) {
        BrooklynMementoRawData.Builder result = BrooklynMementoRawData.builder();
        XmlMementoSerializer rawSerializer = new XmlMementoSerializer(mgmt.getClass().getClassLoader());
        RetryingMementoSerializer<Memento> serializer = new RetryingMementoSerializer<Memento>(rawSerializer, 1);
        result.planeId((String)mgmt.getManagementPlaneIdMaybe().orNull());
        for (Object instance : mgmt.getLocationManager().getLocations()) {
            result.location(instance.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instance)));
        }
        for (Object instance : mgmt.getEntityManager().getEntities()) {
            instance = Entities.deproxy((Entity)instance);
            result.entity(instance.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instance)));
            for (Feed instanceAdjunct : ((EntityInternal)instance).feeds().getFeeds()) {
                result.feed(instanceAdjunct.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instanceAdjunct)));
            }
            for (Feed instanceAdjunct : instance.enrichers()) {
                result.enricher(instanceAdjunct.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instanceAdjunct)));
            }
            for (Feed instanceAdjunct : instance.policies()) {
                result.policy(instanceAdjunct.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instanceAdjunct)));
            }
        }
        for (Object instance : mgmt.getCatalog().getCatalogItemsLegacy()) {
            result.catalogItem(instance.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instance)));
        }
        OsgiManager osgi = (OsgiManager)((LocalManagementContext)mgmt).getOsgiManager().orNull();
        if (osgi != null) {
            for (ManagedBundle instance : osgi.getManagedBundles().values()) {
                result.bundle(instance.getId(), serializer.toString(BrooklynPersistenceUtils.newObjectMemento((BrooklynObject)instance)));
            }
        }
        return result.build();
    }

    public static void writeMemento(ManagementContext mgmt, PersistenceObjectStore targetStore, MementoCopyMode source) {
        if (source == null || source == MementoCopyMode.AUTO) {
            source = mgmt.getHighAvailabilityManager().getNodeState() == ManagementNodeState.MASTER ? MementoCopyMode.LOCAL : MementoCopyMode.REMOTE;
        }
        Stopwatch timer = Stopwatch.createStarted();
        BrooklynMementoRawData dataRecord = BrooklynPersistenceUtils.newStateMemento(mgmt, source);
        ManagementPlaneSyncRecord mgmtRecord = BrooklynPersistenceUtils.newManagerMemento(mgmt, source);
        BrooklynPersistenceUtils.writeMemento(mgmt, dataRecord, targetStore);
        BrooklynPersistenceUtils.writeManagerMemento(mgmt, mgmtRecord, targetStore);
        log.debug("Wrote full memento to " + targetStore + " in " + Time.makeTimeStringRounded((Duration)Duration.of((Object)timer)));
    }

    public static void createBackup(ManagementContext managementContext, CreateBackupMode mode, MementoCopyMode source) {
        block13: {
            if (source == null || source == MementoCopyMode.AUTO) {
                switch (mode) {
                    case PROMOTION: {
                        source = MementoCopyMode.REMOTE;
                        break;
                    }
                    case DEMOTION: {
                        source = MementoCopyMode.LOCAL;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot detect copy mode for " + (Object)((Object)mode) + "/" + source);
                    }
                }
            }
            BrooklynMementoRawData memento = null;
            ManagementPlaneSyncRecord planeState = null;
            try {
                log.debug("Loading persisted state on " + (Object)((Object)mode) + " for backup purposes");
                memento = BrooklynPersistenceUtils.newStateMemento(managementContext, source);
                try {
                    planeState = BrooklynPersistenceUtils.newManagerMemento(managementContext, source);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.warn("Unable to access management plane sync state on " + (Object)((Object)mode) + " (ignoring): " + e, (Throwable)e);
                }
                PersistenceObjectStore destinationObjectStore = null;
                String backupSpec = (String)managementContext.getConfig().getConfig(BrooklynServerConfig.PERSISTENCE_BACKUPS_LOCATION_SPEC);
                String nonBackupSpec = (String)managementContext.getConfig().getConfig(BrooklynServerConfig.PERSISTENCE_LOCATION_SPEC);
                try {
                    String backupContainer = BrooklynServerPaths.newBackupPersistencePathResolver(managementContext).location(backupSpec).nonBackupLocation(nonBackupSpec).resolveWithSubpathFor(managementContext, mode.toString());
                    destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore(managementContext, backupSpec, backupContainer);
                    log.debug("Backing up persisted state on " + (Object)((Object)mode) + ", to " + destinationObjectStore.getSummaryName());
                    BrooklynPersistenceUtils.writeMemento(managementContext, memento, destinationObjectStore);
                    BrooklynPersistenceUtils.writeManagerMemento(managementContext, planeState, destinationObjectStore);
                    if (!memento.isEmpty()) {
                        log.info("Back-up of persisted state created on " + (Object)((Object)mode) + ", in " + destinationObjectStore.getSummaryName());
                        break block13;
                    }
                    log.debug("Back-up of (empty) persisted state created on " + (Object)((Object)mode) + ", in " + destinationObjectStore.getSummaryName());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    PersistenceObjectStore failedStore = destinationObjectStore;
                    if (!Strings.isBlank((CharSequence)backupSpec) && !"localhost".equals(backupSpec)) {
                        String failedSpec = backupSpec;
                        backupSpec = "localhost";
                        String backupContainer = BrooklynServerPaths.newBackupPersistencePathResolver(managementContext).location(backupSpec).nonBackupLocation(nonBackupSpec).resolveWithSubpathFor(managementContext, mode.toString());
                        destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore(managementContext, backupSpec, backupContainer);
                        log.warn("Persisted state back-up to " + (failedStore != null ? failedStore.getSummaryName() : failedSpec) + " failed with " + e, (Throwable)e);
                        log.debug("Backing up persisted state on " + (Object)((Object)mode) + ", locally because remote failed, to " + destinationObjectStore.getSummaryName());
                        BrooklynPersistenceUtils.writeMemento(managementContext, memento, destinationObjectStore);
                        BrooklynPersistenceUtils.writeManagerMemento(managementContext, planeState, destinationObjectStore);
                        log.info("Back-up of persisted state created on " + (Object)((Object)mode) + ", locally because remote failed, in " + destinationObjectStore.getSummaryName());
                    }
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Unable to backup management plane sync state on " + (Object)((Object)mode) + " (ignoring): " + e, (Throwable)e);
            }
        }
    }

    public static enum CreateBackupMode {
        PROMOTION,
        DEMOTION,
        CUSTOM;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

