/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.SubscriptionManager;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.mgmt.internal.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscriptionManager
implements SubscriptionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSubscriptionManager.class);

    protected abstract <T> SubscriptionHandle subscribe(Map<String, Object> var1, Subscription<T> var2);

    public abstract <T> void publish(SensorEvent<T> var1);

    static Object makeEntitySensorToken(Entity e, Sensor<?> s) {
        return new EntitySensorToken(e, s);
    }

    static Object makeEntitySensorToken(SensorEvent<?> se) {
        return AbstractSubscriptionManager.makeEntitySensorToken(se.getSource(), se.getSensor());
    }

    public final <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribe(Collections.emptyMap(), producer, sensor, listener);
    }

    public final <T> SubscriptionHandle subscribe(Map<String, Object> flags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribe(flags, new Subscription<T>(producer, sensor, listener));
    }

    public final <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToChildren(Collections.emptyMap(), parent, sensor, listener);
    }

    public final <T> SubscriptionHandle subscribeToChildren(Map<String, Object> flags, final Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        Predicate eventFilter = new Predicate<SensorEvent<T>>(){

            public boolean apply(SensorEvent<T> input) {
                return parent != null && input.getSource() != null && parent.equals(input.getSource().getParent());
            }
        };
        flags.put("eventFilter", eventFilter);
        return this.subscribe(flags, null, sensor, listener);
    }

    public final <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToMembers(Collections.emptyMap(), parent, sensor, listener);
    }

    public final <T> SubscriptionHandle subscribeToMembers(Map<String, Object> flags, final Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        Predicate eventFilter = new Predicate<SensorEvent<T>>(){

            public boolean apply(SensorEvent<T> input) {
                return parent.getMembers().contains(input.getSource());
            }
        };
        flags.put("eventFilter", eventFilter);
        return this.subscribe(flags, null, sensor, listener);
    }

    protected <T> Object getSubscriber(Map<String, Object> flags, Subscription<T> s) {
        return s.subscriber != null ? s.subscriber : (flags.containsKey("subscriber") ? flags.remove("subscriber") : s.listener);
    }

    public static class EntitySensorToken {
        Entity e;
        Sensor<?> s;
        String sName;

        public EntitySensorToken(Entity e, Sensor<?> s) {
            this.e = e;
            this.s = s;
            this.sName = s == null ? null : (String)Preconditions.checkNotNull((Object)s.getName(), (String)"sensor must have non-null name: %s", (Object[])new Object[]{s});
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.e, this.sName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EntitySensorToken)) {
                return false;
            }
            if (!Objects.equal((Object)this.e, (Object)((EntitySensorToken)obj).e)) {
                return false;
            }
            return Objects.equal((Object)this.sName, (Object)((EntitySensorToken)obj).sName);
        }

        public String toString() {
            return (this.e != null ? this.e.getId() : "*") + ":" + (this.s != null ? this.sName : "*");
        }
    }
}

