/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.drivers.EntityDriverManager;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Scratchpad;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityManager;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.drivers.BasicEntityDriverManager;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadsManager;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.internal.storage.impl.BrooklynStorageImpl;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.HighAvailabilityManagerImpl;
import org.apache.brooklyn.core.mgmt.internal.BasicExternalConfigSupplierRegistry;
import org.apache.brooklyn.core.mgmt.internal.BasicScratchpad;
import org.apache.brooklyn.core.mgmt.internal.BasicSubscriptionContext;
import org.apache.brooklyn.core.mgmt.internal.BrooklynGarbageCollector;
import org.apache.brooklyn.core.mgmt.internal.DeferredBrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.core.mgmt.internal.EntityManagementSupport;
import org.apache.brooklyn.core.mgmt.internal.ExternalConfigSupplierRegistry;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagementContext
implements ManagementContextInternal {
    private static final Logger log = LoggerFactory.getLogger(AbstractManagementContext.class);
    private final AtomicLong totalEffectorInvocationCount = new AtomicLong();
    private final String managementNodeId;
    protected DeferredBrooklynProperties configMap;
    protected Scratchpad scratchpad;
    protected BasicLocationRegistry locationRegistry;
    protected final BasicBrooklynCatalog catalog;
    protected final BrooklynTypeRegistry typeRegistry;
    protected ClassLoader baseClassLoader;
    protected Iterable<URL> baseClassPathForScanning;
    private final RebindManager rebindManager;
    private final HighAvailabilityManager highAvailabilityManager;
    protected volatile BrooklynGarbageCollector gc;
    private final EntityDriverManager entityDriverManager;
    protected DownloadResolverManager downloadsManager;
    protected EntitlementManager entitlementManager;
    private final BrooklynStorage storage;
    protected final ExternalConfigSupplierRegistry configSupplierRegistry;
    private volatile boolean running = true;
    protected boolean startupComplete = false;
    protected final List<Throwable> errors = Collections.synchronizedList(MutableList.of());
    protected Maybe<URI> uri = Maybe.absent();
    private CatalogInitialization catalogInitialization;
    private final Object locationRegistrySemaphore = new Object();
    private Object catalogInitMutex = new Object();

    public AbstractManagementContext(BrooklynProperties brooklynProperties) {
        this.managementNodeId = Strings.makeRandomId((int)8);
        this.configMap = new DeferredBrooklynProperties(brooklynProperties, this);
        this.scratchpad = new BasicScratchpad();
        this.entityDriverManager = new BasicEntityDriverManager();
        this.downloadsManager = BasicDownloadsManager.newDefault(this.configMap);
        this.catalog = new BasicBrooklynCatalog(this);
        this.typeRegistry = new BasicBrooklynTypeRegistry(this);
        this.storage = new BrooklynStorageImpl();
        this.rebindManager = new RebindManagerImpl(this);
        this.highAvailabilityManager = new HighAvailabilityManagerImpl(this);
        this.entitlementManager = Entitlements.newManager(this, brooklynProperties);
        this.configSupplierRegistry = new BasicExternalConfigSupplierRegistry(this);
    }

    @Override
    public void terminate() {
        this.highAvailabilityManager.stop();
        this.running = false;
        this.rebindManager.stop();
        this.storage.terminate();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStartupComplete() {
        return this.startupComplete;
    }

    public String getManagementNodeId() {
        return this.managementNodeId;
    }

    @Override
    public BrooklynStorage getStorage() {
        return this.storage;
    }

    public RebindManager getRebindManager() {
        return this.rebindManager;
    }

    public HighAvailabilityManager getHighAvailabilityManager() {
        return this.highAvailabilityManager;
    }

    @Override
    public long getTotalEffectorInvocations() {
        return this.totalEffectorInvocationCount.get();
    }

    public ExecutionContext getExecutionContext(Entity e) {
        if (e instanceof AbstractEntity) {
            ImmutableSet tags = ImmutableSet.of((Object)BrooklynTaskTags.tagForContextEntity(e), (Object)this);
            return new BasicExecutionContext((Map<?, ?>)MutableMap.of((Object)"tags", (Object)tags), this.getExecutionManager());
        }
        return ((EntityInternal)e).getExecutionContext();
    }

    public ExecutionContext getServerExecutionContext() {
        ImmutableSet tags = ImmutableSet.of((Object)this, (Object)"BROOKLYN-SERVER");
        return new BasicExecutionContext((Map<?, ?>)MutableMap.of((Object)"tags", (Object)tags), this.getExecutionManager());
    }

    public SubscriptionContext getSubscriptionContext(Entity e) {
        ImmutableMap flags = ImmutableMap.of((Object)"tags", (Object)ImmutableList.of((Object)BrooklynTaskTags.tagForContextEntity(e)));
        return new BasicSubscriptionContext((Map<String, ?>)flags, this.getSubscriptionManager(), e);
    }

    public SubscriptionContext getSubscriptionContext(Location loc) {
        return new BasicSubscriptionContext(this.getSubscriptionManager(), loc);
    }

    public EntityDriverManager getEntityDriverManager() {
        return this.entityDriverManager;
    }

    public DownloadResolverManager getEntityDownloadsManager() {
        return this.downloadsManager;
    }

    public EntitlementManager getEntitlementManager() {
        return this.entitlementManager;
    }

    protected abstract void manageIfNecessary(Entity var1, Object var2);

    @Override
    public <T> Task<T> invokeEffector(Entity entity, Effector<T> eff, Map parameters) {
        return this.runAtEntity(entity, eff, parameters);
    }

    protected <T> T invokeEffectorMethodLocal(Entity entity, Effector<T> eff, Map<String, ?> args) {
        assert (this.isManagedLocally(entity)) : "cannot invoke effector method at " + this + " because it is not managed here";
        this.totalEffectorInvocationCount.incrementAndGet();
        Object[] transformedArgs = EffectorUtils.prepareArgsForEffector(eff, args);
        try {
            Maybe result = Reflections.invokeMethodFromArgs((Object)entity, (String)eff.getName(), Arrays.asList(transformedArgs));
            if (result.isPresent()) {
                return (T)result.get();
            }
            throw new IllegalStateException("Unable to invoke entity effector method " + eff.getName() + " on " + entity + " - not found matching args");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public <T> T invokeEffectorMethodSync(final Entity entity, final Effector<T> eff, final Map<String, ?> args) throws ExecutionException {
        try {
            Task current = Tasks.current();
            if (current == null || !entity.equals(BrooklynTaskTags.getContextEntity(current)) || !this.isManagedLocally(entity)) {
                this.manageIfNecessary(entity, eff.getName());
                Task<T> task = this.runAtEntity(EffectorUtils.getTaskFlagsForEffectorInvocation(entity, eff, ConfigBag.newInstance().configureStringKey("args", args)), entity, new Callable<T>(){

                    @Override
                    public T call() {
                        return AbstractManagementContext.this.invokeEffectorMethodLocal(entity, eff, args);
                    }
                });
                return (T)task.get();
            }
            return this.invokeEffectorMethodLocal(entity, eff, args);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public abstract boolean isManagedLocally(Entity var1);

    @Deprecated
    protected abstract <T> Task<T> runAtEntity(Map var1, Entity var2, Callable<T> var3);

    protected abstract <T> Task<T> runAtEntity(Entity var1, Effector<T> var2, Map var3);

    public StringConfigMap getConfig() {
        return this.configMap;
    }

    @Override
    public BrooklynProperties getBrooklynProperties() {
        return this.configMap;
    }

    public Scratchpad getScratchpad() {
        return this.scratchpad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationRegistry getLocationRegistry() {
        Object object = this.locationRegistrySemaphore;
        synchronized (object) {
            if (this.locationRegistry == null) {
                this.locationRegistry = new BasicLocationRegistry(this);
            }
            return this.locationRegistry;
        }
    }

    public BrooklynCatalog getCatalog() {
        if (!this.getCatalogInitialization().hasRunAnyInitialization()) {
            this.getCatalogInitialization().setManagementContext(this);
            this.getCatalogInitialization().populateUnofficial(this.catalog);
        }
        return this.catalog;
    }

    public BrooklynTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public ClassLoader getCatalogClassLoader() {
        return this.catalog.getRootClassLoader();
    }

    @Override
    public ClassLoader getBaseClassLoader() {
        return this.baseClassLoader;
    }

    public void setBaseClassLoader(ClassLoader cl) {
        if (this.baseClassLoader == cl) {
            return;
        }
        if (this.baseClassLoader != null) {
            throw new IllegalStateException("Cannot change base class loader (in " + this + ")");
        }
        if (this.catalog != null) {
            throw new IllegalStateException("Cannot set base class after catalog has been loaded (in " + this + ")");
        }
        this.baseClassLoader = cl;
    }

    @Override
    public void setBaseClassPathForScanning(Iterable<URL> urls) {
        if (Objects.equal(this.baseClassPathForScanning, urls)) {
            return;
        }
        if (this.baseClassPathForScanning != null) {
            if (this.catalog == null) {
                log.warn("Changing scan classpath to " + urls + " from " + this.baseClassPathForScanning);
            } else {
                throw new IllegalStateException("Cannot change base class path for scanning (in " + this + ")");
            }
        }
        this.baseClassPathForScanning = urls;
    }

    @Override
    public Iterable<URL> getBaseClassPathForScanning() {
        return this.baseClassPathForScanning;
    }

    public BrooklynGarbageCollector getGarbageCollector() {
        return this.gc;
    }

    @Override
    public void setManagementNodeUri(URI uri) {
        this.uri = Maybe.of((Object)Preconditions.checkNotNull((Object)uri, (Object)"uri"));
    }

    public Maybe<URI> getManagementNodeUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CatalogInitialization getCatalogInitialization() {
        Object object = this.catalogInitMutex;
        synchronized (object) {
            if (this.catalogInitialization != null) {
                return this.catalogInitialization;
            }
            CatalogInitialization ci = new CatalogInitialization();
            this.setCatalogInitialization(ci);
            return ci;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalogInitialization(CatalogInitialization catalogInitialization) {
        Object object = this.catalogInitMutex;
        synchronized (object) {
            Preconditions.checkNotNull((Object)catalogInitialization, (Object)"initialization must not be null");
            if (this.catalogInitialization != null && this.catalogInitialization != catalogInitialization) {
                throw new IllegalStateException("Changing catalog init from " + this.catalogInitialization + " to " + catalogInitialization + "; changes not permitted");
            }
            catalogInitialization.setManagementContext(this);
            this.catalogInitialization = catalogInitialization;
        }
    }

    public BrooklynObject lookup(String id) {
        return this.lookup(id, BrooklynObject.class);
    }

    public <T extends BrooklynObject> T lookup(String id, Class<T> type) {
        Entity result = this.getEntityManager().getEntity(id);
        if (result != null && type.isInstance(result)) {
            return (T)((BrooklynObject)result);
        }
        result = this.getLocationManager().getLocation(id);
        if (result != null && type.isInstance(result)) {
            return (T)((BrooklynObject)result);
        }
        return null;
    }

    @Override
    public List<Throwable> errors() {
        return this.errors;
    }

    @Override
    public ExternalConfigSupplierRegistry getExternalConfigProviderRegistry() {
        return this.configSupplierRegistry;
    }

    static {
        ResourceUtils.addClassLoaderProvider(new Function<Object, BrooklynClassLoadingContext>(){

            public BrooklynClassLoadingContext apply(@Nullable Object input) {
                if (input instanceof EntityInternal) {
                    EntityInternal internal = (EntityInternal)input;
                    String inputCatalogItemId = internal.getCatalogItemId();
                    if (inputCatalogItemId != null) {
                        RegisteredType item = internal.getManagementContext().getTypeRegistry().get(internal.getCatalogItemId());
                        if (item != null) {
                            List searchPath = internal.getCatalogItemIdSearchPath();
                            ManagementContext managementContext = internal.getManagementContext();
                            BrooklynClassLoadingContextSequential seqLoader = new BrooklynClassLoadingContextSequential(managementContext, new BrooklynClassLoadingContext[0]);
                            seqLoader.add(CatalogUtils.newClassLoadingContextForCatalogItems(managementContext, inputCatalogItemId, searchPath));
                            JavaBrooklynClassLoadingContext entityLoader = JavaBrooklynClassLoadingContext.create(input.getClass().getClassLoader());
                            seqLoader.add(entityLoader);
                            return seqLoader;
                        }
                        log.error("Can't find catalog item " + internal.getCatalogItemId() + " used for instantiating entity " + internal + ". Falling back to application classpath.");
                    }
                    return this.apply(internal.getManagementSupport());
                }
                if (input instanceof EntityManagementSupport) {
                    return this.apply(((EntityManagementSupport)input).getManagementContext());
                }
                if (input instanceof ManagementContext) {
                    return JavaBrooklynClassLoadingContext.create((ManagementContext)input);
                }
                return null;
            }
        });
    }
}

