/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.render;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererHints {
    private static final Logger log = LoggerFactory.getLogger(RendererHints.class);
    private static SetMultimap<Object, Hint<?>> registry = Multimaps.synchronizedSetMultimap((SetMultimap)LinkedHashMultimap.create());

    @VisibleForTesting
    public static SetMultimap<Object, Hint<?>> getRegistry() {
        return registry;
    }

    public static <T> AttributeSensor<T> register(AttributeSensor<T> element, Hint<? super T> hintForThatElement) {
        return RendererHints._register(element, hintForThatElement);
    }

    public static <T> ConfigKey<T> register(ConfigKey<T> element, Hint<? super T> hintForThatElement) {
        return RendererHints._register(element, hintForThatElement);
    }

    public static <T> Class<T> register(Class<T> element, Hint<? super T> hintForThatElement) {
        return RendererHints._register(element, hintForThatElement);
    }

    private static <T> T _register(T element, Hint<?> hintForThatElement) {
        if (element == null) {
            log.error("Invalid null target for renderer hint " + hintForThatElement, new Throwable("Trace for invalid null target for renderer hint"));
        }
        registry.put(element, hintForThatElement);
        return element;
    }

    public static Set<Hint<?>> getHintsFor(AttributeSensor<?> element) {
        return RendererHints._getHintsFor(element, null);
    }

    public static Set<Hint<?>> getHintsFor(ConfigKey<?> element) {
        return RendererHints._getHintsFor(element, null);
    }

    public static Set<Hint<?>> getHintsFor(Class<?> element) {
        return RendererHints._getHintsFor(element, null);
    }

    @Deprecated
    public static Set<Hint<?>> getHintsFor(Object element) {
        return RendererHints.getHintsFor(element, null);
    }

    @Deprecated
    public static Set<Hint<?>> getHintsFor(Object element, Class<? extends Hint> optionalHintSuperClass) {
        return RendererHints._getHintsFor(element, optionalHintSuperClass);
    }

    private static <T extends Hint> Set<T> _getHintsFor(Object element, Class<T> optionalHintSuperClass) {
        Object found = ImmutableSet.copyOf((Collection)registry.get(element));
        if (found.isEmpty() && element instanceof Class && !Object.class.equals(element) && (found = RendererHints._getHintsFor(((Class)element).getSuperclass(), optionalHintSuperClass)).isEmpty()) {
            Class<?> parentInterface;
            Class<?>[] classArray = ((Class)element).getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (found = RendererHints._getHintsFor(parentInterface = classArray[i], optionalHintSuperClass)).isEmpty(); ++i) {
            }
        }
        if (optionalHintSuperClass != null) {
            return Sets.filter((Set)found, (Predicate)Predicates.instanceOf(optionalHintSuperClass));
        }
        return found;
    }

    public static Object applyDisplayValueHint(AttributeSensor<?> target, Object initialValue) {
        return RendererHints.applyDisplayValueHintUnchecked(target, initialValue);
    }

    public static Object applyDisplayValueHint(ConfigKey<?> target, Object initialValue) {
        return RendererHints.applyDisplayValueHintUnchecked(target, initialValue);
    }

    public static Object applyDisplayValueHint(Class<?> target, Object initialValue) {
        return RendererHints.applyDisplayValueHintUnchecked(target, initialValue);
    }

    @Beta
    public static Object applyDisplayValueHintUnchecked(Object target, Object initialValue) {
        return RendererHints._applyDisplayValueHint(target, initialValue, true);
    }

    private static Object _applyDisplayValueHint(Object target, Object initialValue, boolean includeClass) {
        Optional hint;
        Object value;
        Set<DisplayValue> hints = RendererHints._getHintsFor(target, DisplayValue.class);
        if (Iterables.size(hints) > 1) {
            log.warn("Multiple display value hints set for {}; Only one will be applied, using first", target);
        }
        Object object = value = (hint = Optional.fromNullable((Object)Iterables.getFirst(hints, null))).isPresent() ? ((DisplayValue)hint.get()).getDisplayValue(initialValue) : initialValue;
        if (includeClass && value != null && !(value instanceof String) && !(value instanceof Number) && !value.getClass().isPrimitive()) {
            value = RendererHints._applyDisplayValueHint(value.getClass(), value, false);
        }
        return value;
    }

    @Beta
    public static <T> DisplayValue<T> displayValue(Function<T, String> transform) {
        return new DisplayValue(transform);
    }

    @Beta
    public static <T> NamedActionWithUrl<T> namedActionWithUrl(String actionName, Function<T, String> transform) {
        return new NamedActionWithUrl<T>(actionName, transform);
    }

    @Beta
    public static <T> NamedActionWithUrl<T> namedActionWithUrl(String actionName) {
        return new NamedActionWithUrl(actionName);
    }

    @Beta
    public static <T> NamedActionWithUrl<T> namedActionWithUrl(Function<T, String> transform) {
        return RendererHints.openWithUrl(transform);
    }

    @Beta
    public static <T> NamedActionWithUrl<T> namedActionWithUrl() {
        return RendererHints.openWithUrl();
    }

    @Beta
    public static <T> NamedActionWithUrl<T> openWithUrl() {
        return RendererHints.openWithUrl(null);
    }

    @Beta
    public static <T> NamedActionWithUrl<T> openWithUrl(Function<T, String> transform) {
        return new NamedActionWithUrl<T>("Open", transform);
    }

    @Beta
    public static <T> DisplayValue<T> censoredValue() {
        return new DisplayValue(Functions.constant((Object)"********"));
    }

    @Beta
    public static class DisplayValue<T>
    extends Hint<T> {
        private final Function<Object, String> transform;

        protected DisplayValue(Function<?, String> transform) {
            this.transform = (Function)Preconditions.checkNotNull(transform, (Object)"transform");
        }

        public String getDisplayValue(Object v) {
            String dv = (String)this.transform.apply(v);
            return Strings.nullToEmpty((String)dv);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.transform});
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof DisplayValue)) {
                return false;
            }
            return Objects.equal(this.transform, ((DisplayValue)obj).transform);
        }
    }

    public static class NamedActionWithUrl<T>
    extends Hint<T>
    implements NamedAction {
        private final String actionName;
        private final Function<T, String> postProcessing;

        public NamedActionWithUrl(String actionName) {
            this(actionName, (Function)null);
        }

        @Deprecated
        public NamedActionWithUrl(String actionName, Closure<String> postProcessing) {
            this.actionName = actionName;
            this.postProcessing = postProcessing == null ? null : GroovyJavaMethods.functionFromClosure(postProcessing);
        }

        public NamedActionWithUrl(String actionName, Function<T, String> postProcessing) {
            this.actionName = actionName;
            this.postProcessing = postProcessing;
        }

        @Deprecated
        public String getUrl(Entity e, AttributeSensor<T> s) {
            return this.getUrlFromValue(e.getAttribute(s));
        }

        @Override
        public String getActionName() {
            return this.actionName;
        }

        public String getUrlFromValue(T v) {
            String v2;
            if (this.postProcessing != null) {
                v2 = (String)this.postProcessing.apply(v);
            } else {
                String string = v2 = v == null ? null : v.toString();
            }
            if (v2 == null) {
                return v2;
            }
            return v2.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.actionName, this.postProcessing});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamedActionWithUrl)) {
                return false;
            }
            NamedActionWithUrl o = (NamedActionWithUrl)obj;
            return Objects.equal((Object)this.actionName, (Object)o.actionName) && Objects.equal(this.postProcessing, o.postProcessing);
        }
    }

    public static interface NamedAction {
        public String getActionName();
    }

    public static abstract class Hint<T> {
    }
}

