/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import java.util.Map;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class SubElementConfigKey<T>
extends BasicConfigKey<T> {
    private static final long serialVersionUID = -1587240876351450665L;
    public final ConfigKey parent;

    public SubElementConfigKey(ConfigKey parent, Class<T> type, String name) {
        this(parent, type, name, name, null);
    }

    public SubElementConfigKey(ConfigKey parent, Class<T> type, String name, String description) {
        this(parent, type, name, description, null);
    }

    public SubElementConfigKey(ConfigKey parent, Class<T> type, String name, String description, T defaultValue) {
        super(type, name, description, defaultValue);
        this.parent = parent;
    }

    @Override
    public T extractValue(Map vals, ExecutionContext exec) {
        String subName;
        Object parentVals;
        if (vals.containsKey(this)) {
            return super.extractValue(vals, exec);
        }
        if (this.parent instanceof StructuredConfigKey && (parentVals = vals.get(this.parent)) instanceof Map && ((Map)parentVals).containsKey(subName = this.getName().substring(this.parent.getName().length() + 1))) {
            try {
                return (T)this.resolveValue(((Map)parentVals).get(subName), exec);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isSet(Map<?, ?> vals) {
        String subName;
        Object parentVals;
        if (super.isSet(vals)) {
            return true;
        }
        return this.parent instanceof StructuredConfigKey && (parentVals = vals.get(this.parent)) instanceof Map && ((Map)parentVals).containsKey(subName = this.getName().substring(this.parent.getName().length() + 1));
    }
}

