/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.guava.SerializablePredicate;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.WildcardGlobs;

public class ConfigPredicates {
    @Deprecated
    private static Predicate<ConfigKey<?>> startingWithOld(final String prefix) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && input.getName().startsWith(prefix);
            }
        };
    }

    @Deprecated
    private static Predicate<ConfigKey<?>> matchingGlobOld(final String glob) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && WildcardGlobs.isGlobMatched((String)glob, (String)input.getName());
            }
        };
    }

    @Deprecated
    private static Predicate<ConfigKey<?>> matchingRegexOld(String regex) {
        final Pattern p = Pattern.compile(regex);
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && p.matcher(input.getName()).matches();
            }
        };
    }

    @Deprecated
    private static Predicate<ConfigKey<?>> nameMatchingOld(final Predicate<String> filter) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && filter.apply((Object)input.getName());
            }
        };
    }

    @Deprecated
    public static Predicate<ConfigKey<?>> startingWith(String prefix) {
        return ConfigPredicates.nameStartsWith(prefix);
    }

    @Deprecated
    public static Predicate<ConfigKey<?>> matchingGlob(String glob) {
        return ConfigPredicates.nameMatchesGlob(glob);
    }

    @Deprecated
    public static Predicate<ConfigKey<?>> matchingRegex(String regex) {
        return ConfigPredicates.nameMatchesRegex(regex);
    }

    @Deprecated
    public static Predicate<ConfigKey<?>> nameMatching(Predicate<String> filter) {
        return ConfigPredicates.nameSatisfies(filter);
    }

    public static Predicate<ConfigKey<?>> nameStartsWith(String prefix) {
        return ConfigPredicates.nameSatisfies((Predicate<? super String>)StringPredicates.startsWith((String)prefix));
    }

    public static Predicate<ConfigKey<?>> nameMatchesGlob(String glob) {
        return ConfigPredicates.nameSatisfies((Predicate<? super String>)StringPredicates.matchesGlob((String)glob));
    }

    public static Predicate<ConfigKey<?>> nameMatchesRegex(String regex) {
        return ConfigPredicates.nameSatisfies((Predicate<? super String>)StringPredicates.matchesRegex((String)regex));
    }

    public static Predicate<ConfigKey<?>> nameEqualTo(String val) {
        return ConfigPredicates.nameSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<ConfigKey<?>> nameSatisfies(Predicate<? super String> condition) {
        return new NameSatisfies(condition);
    }

    protected static class NameSatisfies
    implements SerializablePredicate<ConfigKey<?>> {
        protected final Predicate<? super String> condition;

        protected NameSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable ConfigKey<?> input) {
            return input != null && this.condition.apply((Object)input.getName());
        }

        public String toString() {
            return "displayNameSatisfies(" + this.condition + ")";
        }
    }
}

