/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConstraintViolationException;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectPredicate;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigConstraints<T extends BrooklynObject> {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigConstraints.class);
    private final T brooklynObject;

    public static void assertValid(Entity entity) {
        Iterable<ConfigKey<?>> violations = new EntityConfigConstraints(entity).getViolations();
        if (!Iterables.isEmpty(violations)) {
            throw new ConstraintViolationException(ConfigConstraints.errorMessage((BrooklynObject)entity, violations));
        }
    }

    public static void assertValid(EntityAdjunct adjunct) {
        Iterable<ConfigKey<?>> violations = new EntityAdjunctConstraints(adjunct).getViolations();
        if (!Iterables.isEmpty(violations)) {
            throw new ConstraintViolationException(ConfigConstraints.errorMessage((BrooklynObject)adjunct, violations));
        }
    }

    public static <T> void assertValid(Entity entity, ConfigKey<T> key, T value) {
        if (!new EntityConfigConstraints(entity).isValueValid(key, value)) {
            throw new ConstraintViolationException("Invalid value for " + key + " on " + entity + ": " + value);
        }
    }

    public static <T> void assertValid(Location location, ConfigKey<T> key, T value) {
        if (!new LocationConfigConstraints(location).isValueValid(key, value)) {
            throw new ConstraintViolationException("Invalid value for " + key + " on " + location + ": " + value);
        }
    }

    private static String errorMessage(BrooklynObject object, Iterable<ConfigKey<?>> violations) {
        StringBuilder message = new StringBuilder("Error configuring ").append(object.getDisplayName()).append(": [");
        Iterator<ConfigKey<?>> it = violations.iterator();
        while (it.hasNext()) {
            ConfigKey<?> config = it.next();
            message.append(config.getName()).append(":").append(config.getConstraint());
            if (!it.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]").toString();
    }

    public ConfigConstraints(T brooklynObject) {
        this.brooklynObject = brooklynObject;
    }

    abstract Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys();

    public Iterable<ConfigKey<?>> getViolations() {
        return this.validateAll();
    }

    private Iterable<ConfigKey<?>> validateAll() {
        LinkedList violating = Lists.newLinkedList();
        Iterable<ConfigKey<?>> configKeys = this.getBrooklynObjectTypeConfigKeys();
        LOG.trace("Checking config keys on {}: {}", this.getBrooklynObject(), configKeys);
        for (ConfigKey<?> configKey : configKeys) {
            ConfigKey<?> ck;
            BrooklynObjectInternal.ConfigurationSupportInternal configInternal = this.getConfigurationSupportInternal();
            Maybe<?> maybeValue = configInternal.getNonBlocking(configKey);
            if (!maybeValue.isPresent() || this.isValueValid(ck = configKey, maybeValue.get())) continue;
            violating.add(configKey);
        }
        return violating;
    }

    <V> boolean isValueValid(ConfigKey<V> configKey, V value) {
        try {
            Predicate po = configKey.getConstraint();
            if (po instanceof BrooklynObjectPredicate) {
                return ((BrooklynObjectPredicate)BrooklynObjectPredicate.class.cast(po)).apply(value, (BrooklynObject)this.brooklynObject);
            }
            return po.apply(value);
        }
        catch (Exception e) {
            LOG.debug("Error checking constraint on " + configKey.getName(), (Throwable)e);
            return true;
        }
    }

    private BrooklynObjectInternal.ConfigurationSupportInternal getConfigurationSupportInternal() {
        return ((BrooklynObjectInternal)this.brooklynObject).config();
    }

    protected T getBrooklynObject() {
        return this.brooklynObject;
    }

    private static class LocationConfigConstraints
    extends ConfigConstraints<Location> {
        public LocationConfigConstraints(Location brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return Collections.emptyList();
        }
    }

    private static class EntityAdjunctConstraints
    extends ConfigConstraints<EntityAdjunct> {
        public EntityAdjunctConstraints(EntityAdjunct brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return ((AbstractEntityAdjunct)this.getBrooklynObject()).getAdjunctType().getConfigKeys();
        }
    }

    private static class EntityConfigConstraints
    extends ConfigConstraints<Entity> {
        public EntityConfigConstraints(Entity brooklynObject) {
            super(brooklynObject);
        }

        @Override
        Iterable<ConfigKey<?>> getBrooklynObjectTypeConfigKeys() {
            return ((Entity)this.getBrooklynObject()).getEntityType().getConfigKeys();
        }
    }
}

