/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.util.OsgiCompat;
import org.apache.brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.StringEscapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(WebResourceUtils.class);
    public static final Map<String, MediaType> IMAGE_FORMAT_MIME_TYPES = ImmutableMap.builder().put((Object)"jpg", (Object)MediaType.JPEG).put((Object)"jpeg", (Object)MediaType.JPEG).put((Object)"png", (Object)MediaType.PNG).put((Object)"gif", (Object)MediaType.GIF).put((Object)"svg", (Object)MediaType.SVG_UTF_8).build();

    public static WebApplicationException throwWebApplicationException(Response.Status status, String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(status, null, format, args);
    }

    public static WebApplicationException throwWebApplicationException(Response.Status status, Throwable exception) {
        return WebResourceUtils.throwWebApplicationException(status, exception, null, new Object[0]);
    }

    public static WebApplicationException throwWebApplicationException(Response.Status status, Throwable exception, String format, Object ... args) {
        String suppliedMsg;
        String fullMsg = suppliedMsg = format == null ? null : String.format(format, args);
        if (exception != null) {
            fullMsg = fullMsg == null ? Exceptions.collapseText((Throwable)exception) : suppliedMsg + ": " + Exceptions.collapseText((Throwable)exception);
        }
        if (log.isDebugEnabled()) {
            log.debug("responding {} {} ({})", new Object[]{status.getStatusCode(), status.getReasonPhrase(), fullMsg});
        }
        ApiError apiError = (exception != null ? ApiError.builderFromThrowable((Throwable)exception).prefixMessage(suppliedMsg) : ApiError.builder().message(fullMsg == null ? "" : fullMsg)).errorCode(status).build();
        throw new WebApplicationException(exception == null ? new Throwable(apiError.toString()) : (suppliedMsg == null ? exception : new PropagatedRuntimeException(suppliedMsg, exception)), apiError.asJsonResponse());
    }

    public static WebApplicationException serverError(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, format, args);
    }

    public static WebApplicationException badRequest(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.BAD_REQUEST, format, args);
    }

    public static WebApplicationException badRequest(Throwable t) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.BAD_REQUEST, t);
    }

    public static WebApplicationException badRequest(Throwable t, String prefix, Object ... prefixArgs) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.BAD_REQUEST, t, prefix, prefixArgs);
    }

    public static WebApplicationException unauthorized(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.UNAUTHORIZED, format, args);
    }

    public static WebApplicationException forbidden(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.FORBIDDEN, format, args);
    }

    public static WebApplicationException notFound(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.NOT_FOUND, format, args);
    }

    public static WebApplicationException preconditionFailed(String format, Object ... args) {
        return WebResourceUtils.throwWebApplicationException(Response.Status.PRECONDITION_FAILED, format, args);
    }

    public static javax.ws.rs.core.MediaType getImageMediaTypeFromExtension(String extension) {
        MediaType mime = IMAGE_FORMAT_MIME_TYPES.get(extension.toLowerCase());
        if (mime == null) {
            return null;
        }
        try {
            return javax.ws.rs.core.MediaType.valueOf((String)mime.toString());
        }
        catch (Exception e) {
            log.warn("Unparseable MIME type " + mime + "; ignoring (" + e + ")");
            Exceptions.propagateIfFatal((Throwable)e);
            return null;
        }
    }

    public static Object getValueForDisplay(Object value, boolean preferJson, boolean isJerseyReturnValue) {
        return WebResourceUtils.getValueForDisplay(null, value, preferJson, isJerseyReturnValue);
    }

    public static Object getValueForDisplay(ObjectMapper mapper, Object value, boolean preferJson, boolean isJerseyReturnValue) {
        if (preferJson) {
            if (value == null) {
                return null;
            }
            Object result = value;
            result = value;
            if (isJerseyReturnValue && result instanceof String) {
                result = StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)result));
            }
            return result;
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String getPathFromVersionedId(String versionedId) {
        if (RegisteredTypeNaming.isUsableTypeColonVersion((String)versionedId)) {
            String symbolicName = CatalogUtils.getSymbolicNameFromVersionedId((String)versionedId);
            String version = CatalogUtils.getVersionFromVersionedId((String)versionedId);
            return Urls.encode((String)symbolicName) + "/" + Urls.encode((String)version);
        }
        return Urls.encode((String)versionedId);
    }

    @Deprecated
    public static void applyJsonResponse(ServletContext servletContext, Response source, HttpServletResponse target) throws IOException {
        WebResourceUtils.applyJsonResponse(OsgiCompat.getManagementContext(servletContext), source, target);
    }

    public static void applyJsonResponse(ManagementContext mgmt, Response source, HttpServletResponse target) throws IOException {
        target.setStatus(source.getStatus());
        target.setContentType("application/json");
        target.setCharacterEncoding("UTF-8");
        target.getWriter().write(BrooklynJacksonJsonProvider.findAnyObjectMapper(mgmt).writeValueAsString(source.getEntity()));
    }

    public static UriBuilder resourceUriBuilder(UriBuilder baseUriBuilder, Class<?> resourceClass) {
        return UriBuilder.fromPath((String)baseUriBuilder.build(new Object[0]).getPath()).path(resourceClass);
    }

    public static UriBuilder serviceUriBuilder(UriBuilder baseUriBuilder, Class<?> resourceClass, String method) {
        return WebResourceUtils.resourceUriBuilder(baseUriBuilder, resourceClass).path(resourceClass, method);
    }

    public static UriBuilder serviceAbsoluteUriBuilder(UriBuilder baseUriBuilder, Class<?> resourceClass, String method) {
        return baseUriBuilder.path(resourceClass).path(resourceClass, method);
    }
}

