/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.AbstractSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSecurityProvider
extends AbstractSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(LdapSecurityProvider.class);
    public static final String LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String ldapUrl;
    private final String ldapRealm;
    private final String organizationUnit;
    static boolean triedLoading = false;

    public LdapSecurityProvider(ManagementContext mgmt) {
        StringConfigMap properties = mgmt.getConfig();
        this.ldapUrl = (String)properties.getConfig(BrooklynWebConfig.LDAP_URL);
        Strings.checkNonEmpty((CharSequence)this.ldapUrl, (String)("LDAP security provider configuration missing required property " + BrooklynWebConfig.LDAP_URL));
        this.ldapRealm = CharMatcher.isNot((char)'\"').retainFrom((CharSequence)properties.getConfig(BrooklynWebConfig.LDAP_REALM));
        Strings.checkNonEmpty((CharSequence)this.ldapRealm, (String)("LDAP security provider configuration missing required property " + BrooklynWebConfig.LDAP_REALM));
        if (Strings.isBlank((CharSequence)((CharSequence)properties.getConfig(BrooklynWebConfig.LDAP_OU)))) {
            LOG.info("Setting LDAP ou attribute to: Users");
            this.organizationUnit = "Users";
        } else {
            this.organizationUnit = CharMatcher.isNot((char)'\"').retainFrom((CharSequence)properties.getConfig(BrooklynWebConfig.LDAP_OU));
        }
        Strings.checkNonEmpty((CharSequence)this.ldapRealm, (String)("LDAP security provider configuration missing required property " + BrooklynWebConfig.LDAP_OU));
    }

    public LdapSecurityProvider(String ldapUrl, String ldapRealm, String organizationUnit) {
        this.ldapUrl = ldapUrl;
        this.ldapRealm = ldapRealm;
        this.organizationUnit = organizationUnit;
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        if (session == null || user == null) {
            return false;
        }
        LdapSecurityProvider.checkCanLoad();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.getUserDN(user));
        env.put("java.naming.security.credentials", password);
        try {
            new InitialDirContext(env);
            return this.allow(session, user);
        }
        catch (NamingException e) {
            return false;
        }
    }

    protected String getUserDN(String user) {
        List domain = Lists.transform(Arrays.asList(this.ldapRealm.split("\\.")), (Function)new Function<String, String>(){

            public String apply(String input) {
                return "dc=" + input;
            }
        });
        String dc = Joiner.on((String)",").join((Iterable)domain).toLowerCase();
        return "cn=" + user + ",ou=" + this.organizationUnit + "," + dc;
    }

    public static synchronized void checkCanLoad() {
        if (triedLoading) {
            return;
        }
        try {
            Class.forName(LDAP_CONTEXT_FACTORY);
            triedLoading = true;
        }
        catch (Throwable e) {
            throw Exceptions.propagate((Throwable)new ClassNotFoundException("Unable to load LDAP classes (com.sun.jndi.ldap.LdapCtxFactory) required for Brooklyn LDAP security provider"));
        }
    }
}

