/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.security.provider.AbstractSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynUserWithRandomPasswordSecurityProvider
extends AbstractSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(BrooklynUserWithRandomPasswordSecurityProvider.class);
    private static final String USER = "brooklyn";
    private final String password = Identifiers.makeRandomId((int)10);

    public BrooklynUserWithRandomPasswordSecurityProvider() {
        LOG.info("Allowing access to web console from localhost or with {}:{}", (Object)USER, (Object)this.password);
    }

    public BrooklynUserWithRandomPasswordSecurityProvider(ManagementContext mgmt) {
        this();
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        if (USER.equals(user) && this.password.equals(password) || this.isRemoteAddressLocalhost(session)) {
            return this.allow(session, user);
        }
        return false;
    }

    private boolean isRemoteAddressLocalhost(HttpSession session) {
        Object remoteAddress = session.getAttribute("request.remoteAddress");
        if (!(remoteAddress instanceof String)) {
            return false;
        }
        if (Networking.isLocalhost((String)((String)remoteAddress))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ": granting passwordless access to " + session + " originating from " + remoteAddress);
            }
            return true;
        }
        LOG.debug(this + ": password required for " + session + " originating from " + remoteAddress);
        return false;
    }

    public String toString() {
        return JavaClassNames.cleanSimpleClassName((Object)this);
    }
}

