/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import javax.servlet.http.HttpSession;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.text.Strings;

public abstract class AbstractSecurityProvider
implements SecurityProvider {
    @Override
    public boolean isAuthenticated(HttpSession session) {
        if (session == null) {
            return false;
        }
        Object value = session.getAttribute(this.getAuthenticationKey());
        return Strings.isNonBlank((CharSequence)Strings.toString((Object)value));
    }

    @Override
    public boolean logout(HttpSession session) {
        if (session == null) {
            return false;
        }
        session.removeAttribute(this.getAuthenticationKey());
        return true;
    }

    protected boolean allow(HttpSession session, String user) {
        session.setAttribute(this.getAuthenticationKey(), (Object)user);
        return true;
    }

    protected String getAuthenticationKey() {
        return this.getClass().getName() + ".AUTHENTICATED";
    }
}

