/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.jaas;

import java.net.URL;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.security.jaas.ManagementContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasUtils {
    private static final Logger log = LoggerFactory.getLogger(JaasUtils.class);
    private static final String JAAS_CONFIG = "java.security.auth.login.config";

    public static void init(ManagementContext mgmt) {
        ManagementContextHolder.setManagementContextStatic(mgmt);
        String config = System.getProperty(JAAS_CONFIG);
        if (config == null) {
            URL configUrl = JaasUtils.class.getResource("/jaas.conf");
            if (configUrl != null) {
                log.debug("Using classpath JAAS config from " + configUrl.toExternalForm());
                System.setProperty(JAAS_CONFIG, configUrl.toExternalForm());
            } else {
                log.error("Can't find java.security.auth.login.config on classpath. Web server authentication will fail.");
            }
        } else {
            log.debug("Using externally configured JAAS at " + config);
        }
    }
}

