/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.jaas;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.jaas.ManagementContextHolder;
import org.apache.brooklyn.rest.security.jaas.SecurityProviderHttpSession;
import org.apache.brooklyn.rest.security.provider.DelegatingSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(BrooklynLoginModule.class);
    public static final String AUTHENTICATED_USER_SESSION_ATTRIBUTE = "brooklyn.user";
    public static final String PROPERTY_BUNDLE_SYMBOLIC_NAME = BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME.getName() + ".symbolicName";
    public static final String PROPERTY_BUNDLE_VERSION = BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME.getName() + ".version";
    public static final String PROPERTY_ROLE = BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME.getName() + ".role";
    public static final String DEFAULT_ROLE = "webconsole";
    private Map<String, ?> options;
    private BundleContext bundleContext;
    private HttpSession providerSession;
    private SecurityProvider provider;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean loginSuccess;
    private boolean commitSuccess;
    private Collection<Principal> principals;

    private static synchronized SecurityProvider createDefaultSecurityProvider(ManagementContext mgmt) {
        return new DelegatingSecurityProvider(mgmt);
    }

    private ManagementContext getManagementContext() {
        return ManagementContextHolder.getManagementContext();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        this.loginSuccess = false;
        this.commitSuccess = false;
        this.initProvider();
    }

    private void initProvider() {
        StringConfigMap brooklynProperties = this.getManagementContext().getConfig();
        this.provider = (SecurityProvider)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE);
        String symbolicName = (String)this.options.get(PROPERTY_BUNDLE_SYMBOLIC_NAME);
        String version = (String)this.options.get(PROPERTY_BUNDLE_VERSION);
        String className = (String)this.options.get(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME.getName());
        if (className != null && symbolicName == null) {
            throw new IllegalStateException("Missing JAAS module property " + PROPERTY_BUNDLE_SYMBOLIC_NAME + " pointing at the bundle where to load the security provider from.");
        }
        if (this.provider != null) {
            return;
        }
        this.provider = (SecurityProvider)this.getManagementContext().getScratchpad().get(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE);
        if (this.provider != null) {
            return;
        }
        if (symbolicName != null) {
            if (className == null) {
                className = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME);
            }
            if (className != null) {
                try {
                    Collection<Bundle> bundles = this.getMatchingBundles(symbolicName, version);
                    if (bundles.isEmpty()) {
                        throw new IllegalStateException("No bundle " + symbolicName + ":" + version + " found");
                    }
                    if (bundles.size() > 1) {
                        log.warn("Found multiple bundles matching symbolicName " + symbolicName + " and version " + version + " while trying to load security provider " + className + ". Will use first one that loads the class successfully.");
                    }
                    this.provider = this.tryLoadClass(className, bundles);
                    if (this.provider == null) {
                        throw new ClassNotFoundException("Unable to load class " + className + " from bundle " + symbolicName + ":" + version);
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new IllegalStateException("Can not load or create security provider " + className + " for bundle " + symbolicName + ":" + version, e);
                }
            }
        } else {
            log.debug("Delegating security provider loading to Brooklyn.");
            this.provider = BrooklynLoginModule.createDefaultSecurityProvider(this.getManagementContext());
        }
        log.debug("Using security provider " + this.provider);
    }

    private SecurityProvider tryLoadClass(String className, Collection<Bundle> bundles) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (Bundle b : bundles) {
            try {
                Class securityProviderType = b.loadClass(className);
                return DelegatingSecurityProvider.createSecurityProviderInstance(this.getManagementContext(), securityProviderType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private Collection<Bundle> getMatchingBundles(String symbolicName, String version) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName) || version != null && !b.getVersion().toString().equals(version)) continue;
            bundles.add(b);
        }
        return bundles;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            this.loginSuccess = false;
            throw new FailedLoginException("Username and password not available");
        }
        NameCallback cbName = new NameCallback("Username: ");
        PasswordCallback cbPassword = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{cbName, cbPassword};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        String user = cbName.getName();
        String password = new String(cbPassword.getPassword());
        this.providerSession = new SecurityProviderHttpSession();
        Request req = this.getJettyRequest();
        if (req != null) {
            String remoteAddr = req.getRemoteAddr();
            this.providerSession.setAttribute("request.remoteAddress", (Object)remoteAddr);
        }
        if (!this.provider.authenticate(this.providerSession, user, password)) {
            this.loginSuccess = false;
            throw new FailedLoginException("Incorrect username or password");
        }
        if (user != null) {
            this.providerSession.setAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE, (Object)user);
        }
        this.principals = new ArrayList<Principal>(2);
        this.principals.add(new UserPrincipal(user));
        String role = (String)this.options.get(PROPERTY_ROLE);
        if (role == null) {
            role = DEFAULT_ROLE;
        }
        if (Strings.isNonEmpty((CharSequence)role)) {
            this.principals.add(new RolePrincipal(role));
        }
        this.loginSuccess = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSuccess) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Can't commit read-only subject");
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.commitSuccess = true;
        return this.loginSuccess;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSuccess && this.commitSuccess) {
            this.removePrincipal();
        }
        this.clear();
        return this.loginSuccess;
    }

    @Override
    public boolean logout() throws LoginException {
        Request req = this.getJettyRequest();
        if (req != null) {
            log.info("REST logging {} out", this.providerSession.getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE));
            this.provider.logout(req.getSession());
            req.getSession().removeAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE);
        } else {
            log.error("Request object not available for logout");
        }
        this.removePrincipal();
        this.clear();
        return true;
    }

    private void removePrincipal() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Read-only subject");
        }
        this.subject.getPrincipals().removeAll(this.principals);
    }

    private void clear() {
        this.subject = null;
        this.callbackHandler = null;
        this.principals = null;
    }

    private Request getJettyRequest() {
        return Optional.ofNullable(HttpConnection.getCurrentConnection()).map(HttpConnection::getHttpChannel).map(HttpChannel::getRequest).orElse(null);
    }

    public static class RolePrincipal
    extends BasicPrincipal {
        public RolePrincipal(String name) {
            super(name);
        }
    }

    public static class UserPrincipal
    extends BasicPrincipal {
        public UserPrincipal(String name) {
            super(name);
        }
    }

    private static class BasicPrincipal
    implements Principal {
        private String name;

        public BasicPrincipal(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BasicPrincipal) {
                return this.name.equals(((BasicPrincipal)obj).name);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name + "]";
        }
    }
}

