/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.WebEntitlementContext;
import org.apache.brooklyn.rest.api.LogoutApi;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class LogoutResource
extends AbstractBrooklynRestResource
implements LogoutApi {
    private static final String BASIC_REALM_WEBCONSOLE = "Basic realm=\"webconsole\"";
    @Context
    HttpServletRequest req;
    @Context
    UriInfo uri;

    public Response logout() {
        WebEntitlementContext ctx = (WebEntitlementContext)Entitlements.getEntitlementContext();
        if (ctx == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No user logged in").header("WWW-Authenticate", (Object)BASIC_REALM_WEBCONSOLE).build();
        }
        URI dest = this.uri.getBaseUriBuilder().path(LogoutApi.class).path(LogoutApi.class, "logoutUser").build(new Object[]{ctx.user()});
        return Response.temporaryRedirect((URI)dest).build();
    }

    public Response unAuthorize() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)BASIC_REALM_WEBCONSOLE).build();
    }

    public Response logoutUser(String user) {
        WebEntitlementContext ctx = (WebEntitlementContext)Entitlements.getEntitlementContext();
        if (user.equals(ctx.user())) {
            this.doLogout();
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)BASIC_REALM_WEBCONSOLE).build();
        }
        return Response.temporaryRedirect((URI)this.uri.getAbsolutePathBuilder().replacePath("/").build(new Object[0])).build();
    }

    private void doLogout() {
        try {
            this.req.logout();
        }
        catch (ServletException e) {
            Exceptions.propagate((Throwable)e);
        }
        this.req.getSession().invalidate();
    }
}

