/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rt.felix;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.osgi.OsgiUtils;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.felix.framework.FrameworkFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedFelixFramework {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedFelixFramework.class);
    private static final String EXTENSION_PROTOCOL = "system";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final Set<String> SYSTEM_BUNDLES = MutableSet.of();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FrameworkFactory newFrameworkFactory() {
        URL url = EmbeddedFelixFramework.class.getClassLoader().getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url == null) throw new IllegalStateException("Could not find framework factory.");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
            String s = br.readLine();
            while (s != null) {
                if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                    FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s).newInstance();
                    return frameworkFactory;
                }
                s = br.readLine();
            }
            throw new IllegalStateException("Could not find framework factory.");
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Framework newFrameworkStarted(String felixCacheDir, boolean clean, Map<?, ?> extraStartupConfig) {
        MutableMap cfg = MutableMap.copyOf(extraStartupConfig);
        if (clean) {
            cfg.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (felixCacheDir != null) {
            cfg.put("org.osgi.framework.storage", felixCacheDir);
        }
        cfg.put("org.osgi.framework.bsnversion", "multiple");
        FrameworkFactory factory = EmbeddedFelixFramework.newFrameworkFactory();
        Stopwatch timer = Stopwatch.createStarted();
        Framework framework = factory.newFramework((Map)cfg);
        try {
            framework.init();
            EmbeddedFelixFramework.installBootBundles(framework);
            framework.start();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        LOG.debug("System bundles are: " + SYSTEM_BUNDLES);
        LOG.debug("OSGi framework started in " + Duration.of((Object)timer));
        return framework;
    }

    public static void stopFramework(Framework framework) throws RuntimeException {
        try {
            if (framework != null) {
                framework.stop();
                framework.waitForStop(0L);
            }
        }
        catch (InterruptedException | BundleException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static void installBootBundles(Framework framework) {
        Enumeration<URL> resources;
        Stopwatch timer = Stopwatch.createStarted();
        LOG.debug("Installing OSGi boot bundles from " + EmbeddedFelixFramework.class.getClassLoader() + "...");
        try {
            resources = EmbeddedFelixFramework.class.getClassLoader().getResources(MANIFEST_PATH);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        BundleContext bundleContext = framework.getBundleContext();
        Map<String, Bundle> installedBundles = EmbeddedFelixFramework.getInstalledBundlesById(bundleContext);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ReferenceWithError<?> installResult = EmbeddedFelixFramework.installExtensionBundle(bundleContext, url, installedBundles, OsgiUtils.getVersionedId((Bundle)framework));
            if (installResult.hasError() && !installResult.masksErrorIfPresent()) {
                LOG.warn("Unable to install manifest from " + url + ": " + installResult.getError(), installResult.getError());
                continue;
            }
            Object result = installResult.getWithoutError();
            if (result instanceof Bundle) {
                String v = OsgiUtils.getVersionedId((Bundle)((Bundle)result));
                SYSTEM_BUNDLES.add(v);
                if (installResult.hasError()) {
                    LOG.debug(installResult.getError().getMessage() + (result != null ? " (" + result + "/" + v + ")" : ""));
                    continue;
                }
                LOG.debug("Installed " + v + " from " + url);
                continue;
            }
            if (!installResult.hasError()) continue;
            LOG.debug(installResult.getError().getMessage());
        }
        LOG.debug("Installed OSGi boot bundles in " + Time.makeTimeStringRounded((Stopwatch)timer) + ": " + Arrays.asList(framework.getBundleContext().getBundles()));
    }

    private static Map<String, Bundle> getInstalledBundlesById(BundleContext bundleContext) {
        Bundle[] bundles;
        HashMap<String, Bundle> installedBundles = new HashMap<String, Bundle>();
        for (Bundle b : bundles = bundleContext.getBundles()) {
            installedBundles.put(OsgiUtils.getVersionedId((Bundle)b), b);
        }
        return installedBundles;
    }

    private static ReferenceWithError<?> installExtensionBundle(BundleContext bundleContext, URL manifestUrl, Map<String, Bundle> installedBundles, String frameworkVersionedId) {
        if ("felix.extensions".equals(manifestUrl.getHost())) {
            return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Skipping install of internal extension bundle from " + manifestUrl));
        }
        try {
            Manifest manifest = EmbeddedFelixFramework.readManifest(manifestUrl);
            if (!EmbeddedFelixFramework.isValidBundle(manifest)) {
                return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Resource at " + manifestUrl + " is not an OSGi bundle: no valid manifest"));
            }
            String versionedId = OsgiUtils.getVersionedId((Manifest)manifest);
            URL bundleUrl = OsgiUtils.getContainerUrl((URL)manifestUrl, (String)MANIFEST_PATH);
            Bundle existingBundle = installedBundles.get(versionedId);
            if (existingBundle != null) {
                if (!bundleUrl.equals(existingBundle.getLocation()) && !versionedId.equals(frameworkVersionedId)) {
                    return ReferenceWithError.newInstanceMaskingError(null, (Throwable)new IllegalArgumentException("Bundle " + versionedId + " (from manifest " + manifestUrl + ") is already installed, from " + existingBundle.getLocation()));
                }
                return ReferenceWithError.newInstanceMaskingError((Object)existingBundle, (Throwable)new IllegalArgumentException("Bundle " + versionedId + " from manifest " + manifestUrl + " is already installed"));
            }
            byte[] jar = EmbeddedFelixFramework.buildExtensionBundle(manifest);
            LOG.debug("Installing boot bundle " + bundleUrl);
            Bundle newBundle = bundleContext.installBundle("system:" + bundleUrl.toString(), (InputStream)new ByteArrayInputStream(jar));
            installedBundles.put(versionedId, newBundle);
            return ReferenceWithError.newInstanceWithoutError((Object)newBundle);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return ReferenceWithError.newInstanceThrowingError(null, (Throwable)new IllegalStateException("Problem installing extension bundle " + manifestUrl + ": " + e, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest readManifest(URL manifestUrl) throws IOException {
        Manifest manifest;
        InputStream in = null;
        try {
            in = manifestUrl.openStream();
            manifest = new Manifest(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return manifest;
    }

    private static byte[] buildExtensionBundle(Manifest manifest) throws IOException {
        Attributes atts = manifest.getMainAttributes();
        atts.remove(new Attributes.Name("Import-Package"));
        atts.remove(new Attributes.Name("Require-Bundle"));
        atts.remove(new Attributes.Name("Bundle-NativeCode"));
        atts.remove(new Attributes.Name("DynamicImport-Package"));
        atts.remove(new Attributes.Name("Bundle-Activator"));
        atts.putValue("Fragment-Host", "system.bundle; extension:=framework");
        ByteArrayOutputStream jar = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream((OutputStream)jar, manifest);
        out.close();
        return jar.toByteArray();
    }

    private static boolean isValidBundle(Manifest manifest) {
        Attributes atts = manifest.getMainAttributes();
        return atts.containsKey(new Attributes.Name("Bundle-ManifestVersion"));
    }

    public static boolean isExtensionBundle(Bundle bundle) {
        String location = bundle.getLocation();
        return location != null && EXTENSION_PROTOCOL.equals(Urls.getProtocol((String)location));
    }
}

