/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.inject.Named;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.Payload;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.Aws4SignerBase;
import org.jclouds.util.Closeables2;

public class Aws4SignerForAuthorizationHeader
extends Aws4SignerBase {
    @Inject
    public Aws4SignerForAuthorizationHeader(SignatureWire signatureWire, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.aws.header.tag") String headerTag, @Provider Supplier<Credentials> creds, @TimeStamp Supplier<Date> timestampProvider, Aws4SignerBase.ServiceAndRegion serviceAndRegion, Crypto crypto) {
        super(signatureWire, headerTag, creds, timestampProvider, serviceAndRegion, crypto);
    }

    protected HttpRequest sign(HttpRequest request) throws HttpException {
        HashCode md5;
        String contentLength;
        Preconditions.checkNotNull((Object)request, (Object)"request is not ready to sign");
        Preconditions.checkNotNull((Object)request.getEndpoint(), (Object)"request is not ready to sign, request.endpoint not present.");
        Payload payload = request.getPayload();
        String host = request.getEndpoint().getHost();
        Date date = (Date)this.timestampProvider.get();
        String timestamp = this.timestampFormat.format(date);
        String datestamp = this.dateFormat.format(date);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on((char)'/').join((Object)datestamp, (Object)region, new Object[]{service, "aws4_request"});
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).removeHeader("Date");
        ImmutableSortedMap.Builder signedHeadersBuilder = ImmutableSortedMap.naturalOrder();
        String contentType = this.getContentType(request);
        if (!Strings.isNullOrEmpty((String)contentType)) {
            requestBuilder.replaceHeader("Content-Type", new String[]{contentType});
            signedHeadersBuilder.put((Object)"Content-Type".toLowerCase(), (Object)contentType);
        }
        if (!Strings.isNullOrEmpty((String)(contentLength = this.getContentLength(request)))) {
            requestBuilder.replaceHeader("Content-Length", new String[]{contentLength});
            signedHeadersBuilder.put((Object)"Content-Length".toLowerCase(), (Object)contentLength);
        }
        String contentMD5 = request.getFirstHeaderOrNull("Content-MD5");
        if (payload != null && (md5 = payload.getContentMetadata().getContentMD5AsHashCode()) != null) {
            contentMD5 = BaseEncoding.base64().encode(md5.asBytes());
        }
        if (contentMD5 != null) {
            requestBuilder.replaceHeader("Content-MD5", new String[]{contentMD5});
            signedHeadersBuilder.put((Object)"Content-MD5".toLowerCase(), (Object)contentMD5);
        }
        host = Aws4SignerForAuthorizationHeader.hostHeaderFor(request.getEndpoint());
        requestBuilder.replaceHeader("Host", new String[]{host});
        signedHeadersBuilder.put((Object)"Host".toLowerCase(), (Object)host);
        if (request.getHeaders().containsKey((Object)"User-Agent")) {
            signedHeadersBuilder.put((Object)"User-Agent".toLowerCase(), (Object)request.getFirstHeaderOrNull("User-Agent"));
        }
        this.appendAmzHeaders(request, (ImmutableMap.Builder<String, String>)signedHeadersBuilder);
        Credentials credentials = (Credentials)this.creds.get();
        if (credentials instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            requestBuilder.replaceHeader("X-Amz-Security-Token", new String[]{token});
            signedHeadersBuilder.put((Object)"X-Amz-Security-Token".toLowerCase(), (Object)token);
        }
        String contentSha256 = this.getPayloadHash(request);
        requestBuilder.replaceHeader("x-amz-content-sha256", new String[]{contentSha256});
        signedHeadersBuilder.put((Object)"x-amz-content-sha256".toLowerCase(), (Object)contentSha256);
        requestBuilder.replaceHeader("X-Amz-Date", new String[]{timestamp});
        signedHeadersBuilder.put((Object)"X-Amz-Date".toLowerCase(), (Object)timestamp);
        ImmutableMap signedHeaders = signedHeadersBuilder.build();
        String stringToSign = this.createStringToSign(request.getMethod(), request.getEndpoint(), (Map<String, String>)signedHeaders, timestamp, credentialScope, contentSha256);
        this.signatureWire.getWireLog().debug("<< " + stringToSign, new Object[0]);
        byte[] signatureKey = this.signatureKey(credentials.credential, datestamp, region, service);
        String signature = BaseEncoding.base16().lowerCase().encode(this.hmacSHA256(stringToSign, signatureKey));
        StringBuilder authorization = new StringBuilder("AWS4-HMAC-SHA256").append(" ");
        authorization.append("Credential=").append(Joiner.on((String)"/").join((Object)credentials.identity, (Object)credentialScope, new Object[0])).append(", ");
        authorization.append("SignedHeaders=").append(Joiner.on((String)";").join((Iterable)signedHeaders.keySet())).append(", ");
        authorization.append("Signature=").append(signature);
        return ((HttpRequest.Builder)requestBuilder.replaceHeader("Authorization", new String[]{authorization.toString()})).build();
    }

    protected String getPayloadHash(HttpRequest request) {
        Payload payload = request.getPayload();
        if (payload == null) {
            return this.getEmptyPayloadContentHash();
        }
        return this.calculatePayloadContentHash(payload);
    }

    protected String getEmptyPayloadContentHash() {
        return BaseEncoding.base16().lowerCase().encode(Aws4SignerForAuthorizationHeader.hash(new ByteArrayInputStream(new byte[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String calculatePayloadContentHash(Payload payload) {
        InputStream payloadStream;
        try {
            payloadStream = payload.openStream();
        }
        catch (IOException e) {
            throw new HttpException("unable to open payload stream to calculate AWS4 signature.");
        }
        try {
            String string = BaseEncoding.base16().lowerCase().encode(Aws4SignerForAuthorizationHeader.hash(payloadStream));
            return string;
        }
        finally {
            this.closeOrResetPayloadStream(payloadStream, payload.isRepeatable());
        }
    }

    void closeOrResetPayloadStream(InputStream payloadStream, boolean repeatable) {
        if (repeatable) {
            Closeables2.closeQuietly((Closeable)payloadStream);
        } else {
            try {
                payloadStream.reset();
            }
            catch (IOException e) {
                throw new HttpException("unable to reset unrepeatable payload stream after calculating AWS4 signature.");
            }
        }
    }
}

