/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.azurecompute.arm.domain.DataDisk;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.IpConfiguration;
import org.jclouds.azurecompute.arm.domain.ManagedDiskParameters;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkProfile;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.OSDisk;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.features.NetworkSecurityGroupApi;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;

@Singleton
public class CleanupResources {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final Predicate<URI> resourceDeleted;
    private final GroupNamingConvention.Factory namingConvention;

    @Inject
    CleanupResources(AzureComputeApi azureComputeApi, @Named(value="jclouds.azurecompute.arm.timeout.resourcedeleted") Predicate<URI> resourceDeleted, GroupNamingConvention.Factory namingConvention) {
        this.api = azureComputeApi;
        this.resourceDeleted = resourceDeleted;
        this.namingConvention = namingConvention;
    }

    public boolean cleanupNode(String id) {
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        String resourceGroupName = resourceGroupAndName.resourceGroup();
        VirtualMachine virtualMachine = this.api.getVirtualMachineApi(resourceGroupName).get(resourceGroupAndName.name());
        if (virtualMachine == null) {
            return true;
        }
        this.logger.debug(">> destroying %s ...", new Object[]{id});
        boolean vmDeleted = this.deleteVirtualMachine(resourceGroupName, virtualMachine);
        this.cleanupVirtualMachineNICs(virtualMachine);
        this.cleanupManagedDisks(virtualMachine);
        this.cleanupAvailabilitySetIfOrphaned(virtualMachine);
        return vmDeleted;
    }

    public boolean cleanupVirtualMachineNICs(VirtualMachine virtualMachine) {
        boolean deleted = true;
        for (NetworkProfile.NetworkInterface nicRef : virtualMachine.properties().networkProfile().networkInterfaces()) {
            String nicResourceGroup = IdReference.extractResourceGroup(nicRef.id());
            String nicName = IdReference.extractName(nicRef.id());
            NetworkInterfaceCard nic = this.api.getNetworkInterfaceCardApi(nicResourceGroup).get(nicName);
            Iterable<IdReference> publicIps = this.getPublicIps(nic);
            this.logger.debug(">> destroying nic %s...", new Object[]{nicName});
            URI nicDeletionURI = this.api.getNetworkInterfaceCardApi(nicResourceGroup).delete(nicName);
            deleted &= nicDeletionURI == null || this.resourceDeleted.apply((Object)nicDeletionURI);
            for (IdReference publicIp : publicIps) {
                String publicIpResourceGroup = publicIp.resourceGroup();
                String publicIpName = publicIp.name();
                PublicIPAddress ip = this.api.getPublicIPAddressApi(publicIpResourceGroup).get(publicIpName);
                if (ip.tags() == null || !Boolean.parseBoolean(ip.tags().get("jclouds-autogenerated"))) continue;
                this.logger.debug(">> deleting public ip %s...", new Object[]{publicIpName});
                deleted &= this.api.getPublicIPAddressApi(publicIpResourceGroup).delete(publicIpName);
            }
        }
        return deleted;
    }

    public boolean cleanupManagedDisks(VirtualMachine virtualMachine) {
        HashMap<String, URI> deleteJobs = new HashMap<String, URI>();
        OSDisk osDisk = virtualMachine.properties().storageProfile().osDisk();
        this.deleteManagedDisk(osDisk.managedDiskParameters(), deleteJobs);
        for (DataDisk dataDisk : virtualMachine.properties().storageProfile().dataDisks()) {
            this.deleteManagedDisk(dataDisk.managedDiskParameters(), deleteJobs);
        }
        Set nonDeletedDisks = Maps.filterValues(deleteJobs, (Predicate)Predicates.not(this.resourceDeleted)).keySet();
        if (!nonDeletedDisks.isEmpty()) {
            this.logger.warn(">> could not delete disks: %s", new Object[]{Joiner.on((char)',').join(nonDeletedDisks)});
        }
        return nonDeletedDisks.isEmpty();
    }

    private void deleteManagedDisk(@Nullable ManagedDiskParameters managedDisk, Map<String, URI> deleteJobs) {
        if (managedDisk != null) {
            IdReference diskRef = IdReference.create(managedDisk.id());
            this.logger.debug(">> deleting managed disk %s...", new Object[]{diskRef.name()});
            URI uri = this.api.getDiskApi(diskRef.resourceGroup()).delete(diskRef.name());
            if (uri != null) {
                deleteJobs.put(diskRef.name(), uri);
            }
        }
    }

    public boolean cleanupSecurityGroupIfOrphaned(String resourceGroup, String group) {
        String name = this.namingConvention.create().sharedNameForGroup(group);
        NetworkSecurityGroupApi sgapi = this.api.getNetworkSecurityGroupApi(resourceGroup);
        boolean deleted = false;
        try {
            List<NetworkInterfaceCard> nics;
            NetworkSecurityGroup securityGroup = sgapi.get(name);
            if (securityGroup != null && ((nics = securityGroup.properties().networkInterfaces()) == null || nics.isEmpty())) {
                this.logger.debug(">> deleting orphaned security group %s from %s...", new Object[]{name, resourceGroup});
                try {
                    deleted = this.resourceDeleted.apply((Object)sgapi.delete(name));
                }
                catch (Exception ex) {
                    this.logger.warn((Throwable)ex, ">> error deleting orphaned security group %s from %s...", new Object[]{name, resourceGroup});
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn((Throwable)ex, "Error deleting security groups for %s and group %s", new Object[]{resourceGroup, group});
        }
        return deleted;
    }

    public boolean cleanupAvailabilitySetIfOrphaned(VirtualMachine virtualMachine) {
        boolean deleted = true;
        IdReference availabilitySetRef = virtualMachine.properties().availabilitySet();
        if (availabilitySetRef != null) {
            String name = availabilitySetRef.name();
            String resourceGroup = availabilitySetRef.resourceGroup();
            AvailabilitySet availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).get(name);
            if (CleanupResources.isOrphanedJcloudsAvailabilitySet(availabilitySet)) {
                this.logger.debug(">> deleting orphaned availability set %s from %s...", new Object[]{name, resourceGroup});
                URI uri = this.api.getAvailabilitySetApi(resourceGroup).delete(name);
                deleted = uri == null || this.resourceDeleted.apply((Object)uri);
            }
        }
        return deleted;
    }

    public boolean deleteResourceGroupIfEmpty(String group) {
        boolean deleted = false;
        if (this.api.getResourceGroupApi().resources(group).isEmpty()) {
            this.logger.debug(">> the resource group %s is empty. Deleting...", new Object[]{group});
            deleted = this.resourceDeleted.apply((Object)this.api.getResourceGroupApi().delete(group));
        }
        return deleted;
    }

    private Iterable<IdReference> getPublicIps(NetworkInterfaceCard nic) {
        return Iterables.filter((Iterable)Iterables.transform(nic.properties().ipConfigurations(), (Function)new Function<IpConfiguration, IdReference>(){

            public IdReference apply(IpConfiguration input) {
                return input.properties().publicIPAddress();
            }
        }), (Predicate)Predicates.notNull());
    }

    private static boolean isOrphanedJcloudsAvailabilitySet(AvailabilitySet availabilitySet) {
        return availabilitySet != null && availabilitySet.tags() != null && availabilitySet.tags().containsKey("jclouds") && (availabilitySet.properties().virtualMachines() == null || availabilitySet.properties().virtualMachines().isEmpty());
    }

    private boolean deleteVirtualMachine(String group, VirtualMachine virtualMachine) {
        return this.resourceDeleted.apply((Object)this.api.getVirtualMachineApi(group).delete(virtualMachine.name()));
    }
}

