/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.config.AzureComputeServiceContextModule;
import org.jclouds.azurecompute.arm.compute.domain.LocationAndName;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.compute.functions.CustomImageToVMImage;
import org.jclouds.azurecompute.arm.compute.functions.VMImageToImage;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.compute.options.IpOptions;
import org.jclouds.azurecompute.arm.compute.strategy.CleanupResources;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.azurecompute.arm.domain.CreationData;
import org.jclouds.azurecompute.arm.domain.DataDisk;
import org.jclouds.azurecompute.arm.domain.HardwareProfile;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.ImageReference;
import org.jclouds.azurecompute.arm.domain.IpConfiguration;
import org.jclouds.azurecompute.arm.domain.IpConfigurationProperties;
import org.jclouds.azurecompute.arm.domain.Location;
import org.jclouds.azurecompute.arm.domain.ManagedDiskParameters;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCardProperties;
import org.jclouds.azurecompute.arm.domain.NetworkProfile;
import org.jclouds.azurecompute.arm.domain.OSDisk;
import org.jclouds.azurecompute.arm.domain.OSProfile;
import org.jclouds.azurecompute.arm.domain.Offer;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.PublicIPAddressProperties;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.ResourceProviderMetaData;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.azurecompute.arm.domain.StorageAccountType;
import org.jclouds.azurecompute.arm.domain.StorageProfile;
import org.jclouds.azurecompute.arm.domain.VMHardware;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.azurecompute.arm.domain.VMSize;
import org.jclouds.azurecompute.arm.domain.Version;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.azurecompute.arm.features.NetworkInterfaceCardApi;
import org.jclouds.azurecompute.arm.features.OSImageApi;
import org.jclouds.azurecompute.arm.util.VMImages;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class AzureComputeServiceAdapter
implements ComputeServiceAdapter<VirtualMachine, VMHardware, VMImage, Location> {
    public static final String GROUP_KEY = "jclouds_group";
    public static final String AUTOGENERATED_IP_KEY = "jclouds-autogenerated";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CleanupResources cleanupResources;
    private final AzureComputeApi api;
    private final List<String> imagePublishers;
    private final Supplier<Set<String>> regionIds;
    private final AzureComputeServiceContextModule.PublicIpAvailablePredicateFactory publicIpAvailable;
    private final CustomImageToVMImage customImagetoVmImage;
    private final GroupNamingConvention namingConvention;
    private Predicate<Supplier<Provisionable>> resourceAvailable;

    @Inject
    AzureComputeServiceAdapter(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.publishers") String imagePublishers, CleanupResources cleanupResources, @Region Supplier<Set<String>> regionIds, AzureComputeServiceContextModule.PublicIpAvailablePredicateFactory publicIpAvailable, CustomImageToVMImage customImagetoVmImage, GroupNamingConvention.Factory namingConvention, Predicate<Supplier<Provisionable>> resourceAvailable) {
        this.api = api;
        this.imagePublishers = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)imagePublishers);
        this.cleanupResources = cleanupResources;
        this.regionIds = regionIds;
        this.publicIpAvailable = publicIpAvailable;
        this.customImagetoVmImage = customImagetoVmImage;
        this.namingConvention = namingConvention.create();
        this.resourceAvailable = resourceAvailable;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VirtualMachine> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        String locationName = template.getLocation().getId();
        org.jclouds.compute.domain.Image image = template.getImage();
        String hardwareId = LocationAndName.fromSlashEncoded(template.getHardware().getId()).name();
        AzureTemplateOptions templateOptions = (AzureTemplateOptions)template.getOptions().as(AzureTemplateOptions.class);
        String resourceGroupName = templateOptions.getResourceGroup();
        IdReference availabilitySet = this.getAvailabilitySetIdReference(templateOptions.getAvailabilitySet());
        NetworkProfile networkProfile = this.createNetworkProfile(this.createNetworkInterfaceCards(name, locationName, templateOptions));
        StorageProfile storageProfile = this.createStorageProfile(image, templateOptions.getDataDisks());
        HardwareProfile hardwareProfile = HardwareProfile.builder().vmSize(hardwareId).build();
        OSProfile osProfile = this.createOsProfile(name, template);
        VirtualMachineProperties virtualMachineProperties = VirtualMachineProperties.builder().availabilitySet(availabilitySet).hardwareProfile(hardwareProfile).storageProfile(storageProfile).osProfile(osProfile).networkProfile(networkProfile).build();
        templateOptions.getUserMetadata().put(GROUP_KEY, group);
        Map metadataAndTags = ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue((TemplateOptions)templateOptions);
        Plan plan = VMImageToImage.getMarketplacePlanFromImageMetadata(image);
        VirtualMachine virtualMachine = this.api.getVirtualMachineApi(resourceGroupName).createOrUpdate(name, locationName, virtualMachineProperties, metadataAndTags, plan);
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromResourceGroupAndName(resourceGroupName, name);
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)virtualMachine, resourceGroupAndName.slashEncode(), null);
    }

    public Iterable<VMHardware> listHardwareProfiles() {
        ArrayList hwProfiles = Lists.newArrayList();
        for (Location location : this.listLocations()) {
            List<VMSize> vmSizes = this.api.getVMSizeApi(location.name()).list();
            for (VMSize vmSize : vmSizes) {
                VMHardware hwProfile = VMHardware.create(vmSize.name(), vmSize.numberOfCores(), vmSize.osDiskSizeInMB(), vmSize.resourceDiskSizeInMB(), vmSize.memoryInMB(), vmSize.maxDataDiskCount(), location.name());
                hwProfiles.add(hwProfile);
            }
        }
        return hwProfiles;
    }

    private List<VMImage> getImagesFromPublisher(String publisherName, String location) {
        ArrayList osImagesRef = Lists.newArrayList();
        OSImageApi osImageApi = this.api.getOSImageApi(location);
        List<Offer> offerList = osImageApi.listOffers(publisherName);
        for (Offer offer : offerList) {
            List<SKU> skuList = osImageApi.listSKUs(publisherName, offer.name());
            for (SKU sku : skuList) {
                List<Version> versionList = osImageApi.listVersions(publisherName, offer.name(), sku.name());
                for (Version version : versionList) {
                    Version versionDetails = osImageApi.getVersion(publisherName, offer.name(), sku.name(), version.name());
                    VMImage vmImage = VMImage.azureImage().publisher(publisherName).offer(offer.name()).sku(sku.name()).version(versionDetails.name()).location(location).versionProperties(versionDetails.properties()).build();
                    osImagesRef.add(vmImage);
                }
            }
        }
        return osImagesRef;
    }

    private List<VMImage> listImagesByLocation(String location) {
        ArrayList osImages = Lists.newArrayList();
        for (String publisher : this.imagePublishers) {
            osImages.addAll(this.getImagesFromPublisher(publisher, location));
        }
        return osImages;
    }

    private List<VMImage> listCustomImagesByResourceGroup(String resourceGroup) {
        List<Image> customImgs = this.api.getVirtualMachineImageApi(resourceGroup).list();
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(customImgs, (Predicate)new Predicate<Image>(){

            public boolean apply(Image input) {
                return ((Set)AzureComputeServiceAdapter.this.regionIds.get()).contains(input.location());
            }
        }), (Function)this.customImagetoVmImage));
    }

    public Iterable<VMImage> listImages() {
        ImmutableList.Builder osImages = ImmutableList.builder();
        ArrayList availableLocationNames = Lists.newArrayList((Iterable)Iterables.transform(this.listLocations(), (Function)new Function<Location, String>(){

            public String apply(Location location) {
                return location.name();
            }
        }));
        for (String locationName : availableLocationNames) {
            osImages.addAll(this.listImagesByLocation(locationName));
        }
        for (ResourceGroup resourceGroup : this.api.getResourceGroupApi().list()) {
            osImages.addAll(this.listCustomImagesByResourceGroup(resourceGroup.name()));
        }
        return osImages.build();
    }

    public VMImage getImage(String id) {
        VMImage image = VMImage.decodeFieldsFromUniqueId(id);
        if (image.custom()) {
            Image vmImage = this.api.getVirtualMachineImageApi(image.resourceGroup()).get(image.name());
            return vmImage == null ? null : this.customImagetoVmImage.apply(vmImage);
        }
        String location = image.location();
        String publisher = image.publisher();
        String offer = image.offer();
        String sku = image.sku();
        OSImageApi osImageApi = this.api.getOSImageApi(location);
        List<Version> versions = osImageApi.listVersions(publisher, offer, sku);
        if (!versions.isEmpty()) {
            Version version = osImageApi.getVersion(publisher, offer, sku, versions.get(0).name());
            return VMImage.azureImage().publisher(publisher).offer(offer).sku(sku).version(version.name()).location(location).versionProperties(version.properties()).build();
        }
        return null;
    }

    public Iterable<Location> listLocations() {
        FluentIterable vmLocations = FluentIterable.from(this.api.getResourceProviderApi().get("Microsoft.Compute")).filter((Predicate)new Predicate<ResourceProviderMetaData>(){

            public boolean apply(ResourceProviderMetaData input) {
                return input.resourceType().equals("virtualMachines");
            }
        }).transformAndConcat((Function)new Function<ResourceProviderMetaData, Iterable<String>>(){

            public Iterable<String> apply(ResourceProviderMetaData resourceProviderMetaData) {
                return resourceProviderMetaData.locations();
            }
        });
        ImmutableList locations = FluentIterable.from(this.api.getLocationApi().list()).filter((Predicate)new Predicate<Location>((Iterable)vmLocations){
            final /* synthetic */ Iterable val$vmLocations;
            {
                this.val$vmLocations = iterable;
            }

            public boolean apply(Location location) {
                return Iterables.contains((Iterable)this.val$vmLocations, (Object)location.displayName());
            }
        }).filter((Predicate)new Predicate<Location>(){

            public boolean apply(Location location) {
                return ((Set)AzureComputeServiceAdapter.this.regionIds.get()).isEmpty() ? true : ((Set)AzureComputeServiceAdapter.this.regionIds.get()).contains(location.name());
            }
        }).toList();
        return locations;
    }

    public VirtualMachine getNode(String id) {
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        return this.api.getVirtualMachineApi(resourceGroupAndName.resourceGroup()).get(resourceGroupAndName.name());
    }

    public void destroyNode(String id) {
        Preconditions.checkState((boolean)this.cleanupResources.cleanupNode(id), (String)"server(%s) and its resources still there after deleting!?", (Object[])new Object[]{id});
    }

    public void rebootNode(String id) {
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        this.api.getVirtualMachineApi(resourceGroupAndName.resourceGroup()).restart(resourceGroupAndName.name());
    }

    public void resumeNode(String id) {
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        this.api.getVirtualMachineApi(resourceGroupAndName.resourceGroup()).start(resourceGroupAndName.name());
    }

    public void suspendNode(String id) {
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        this.api.getVirtualMachineApi(resourceGroupAndName.resourceGroup()).stop(resourceGroupAndName.name());
    }

    public Iterable<VirtualMachine> listNodes() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (ResourceGroup resourceGroup : this.api.getResourceGroupApi().list()) {
            List<VirtualMachine> vms = this.api.getVirtualMachineApi(resourceGroup.name()).list();
            nodes.addAll(Iterables.filter(vms, (Predicate)new Predicate<VirtualMachine>(){

                public boolean apply(VirtualMachine input) {
                    return ((Set)AzureComputeServiceAdapter.this.regionIds.get()).contains(input.location());
                }
            }));
        }
        return nodes.build();
    }

    public Iterable<VirtualMachine> listNodesByIds(Iterable<String> ids) {
        return Iterables.transform(ids, (Function)new Function<String, VirtualMachine>(){

            public VirtualMachine apply(String input) {
                return AzureComputeServiceAdapter.this.getNode(input);
            }
        });
    }

    private OSProfile createOsProfile(String computerName, Template template) {
        AzureTemplateOptions azureTemplateOptions;
        String defaultLoginUser = template.getImage().getDefaultCredentials().getUser();
        String defaultLoginPassword = (String)template.getImage().getDefaultCredentials().getOptionalPassword().get();
        String adminUsername = (String)Objects.firstNonNull((Object)template.getOptions().getLoginUser(), (Object)defaultLoginUser);
        String adminPassword = (String)Objects.firstNonNull((Object)template.getOptions().getLoginPassword(), (Object)defaultLoginPassword);
        OSProfile.Builder builder = OSProfile.builder().adminUsername(adminUsername).adminPassword(adminPassword).computerName(computerName);
        if (template.getOptions().getPublicKey() != null && OsFamily.WINDOWS != template.getImage().getOperatingSystem().getFamily()) {
            OSProfile.LinuxConfiguration linuxConfiguration = OSProfile.LinuxConfiguration.create("true", OSProfile.LinuxConfiguration.SSH.create((List<OSProfile.LinuxConfiguration.SSH.SSHPublicKey>)ImmutableList.of((Object)OSProfile.LinuxConfiguration.SSH.SSHPublicKey.create(String.format("/home/%s/.ssh/authorized_keys", adminUsername), template.getOptions().getPublicKey()))));
            builder.linuxConfiguration(linuxConfiguration);
        }
        if ((azureTemplateOptions = (AzureTemplateOptions)template.getOptions().as(AzureTemplateOptions.class)).getWindowsConfiguration() != null) {
            builder.windowsConfiguration(azureTemplateOptions.getWindowsConfiguration());
        }
        if (azureTemplateOptions.getSecrets() != null) {
            builder.secrets(azureTemplateOptions.getSecrets());
        }
        return builder.build();
    }

    private List<NetworkInterfaceCard> createNetworkInterfaceCards(final String nodeName, final String location, AzureTemplateOptions options) {
        final String securityGroup = (String)Iterables.getOnlyElement((Iterable)options.getGroups(), null);
        return Lists.transform(AzureComputeServiceAdapter.publicIpsFirst(options.getIpOptions()), (Function)new Function<IpOptions, NetworkInterfaceCard>(){

            public NetworkInterfaceCard apply(IpOptions input) {
                return AzureComputeServiceAdapter.this.createNetworkInterfaceCard(input, nodeName, location, securityGroup);
            }
        });
    }

    private NetworkInterfaceCard createNetworkInterfaceCard(IpOptions ipConfig, String nodeName, String location, String securityGroup) {
        String resourceGroup = IdReference.extractResourceGroup(ipConfig.subnet());
        String subnetName = IdReference.extractName(ipConfig.subnet());
        IpConfigurationProperties.Builder ipProperties = IpConfigurationProperties.builder().subnet(IdReference.create(ipConfig.subnet())).privateIPAllocationMethod(ipConfig.address().isPresent() ? "Static" : "Dynamic").privateIPAddress((String)ipConfig.address().orNull());
        this.configurePublicIP(ipConfig, ipProperties, resourceGroup, location, nodeName);
        String ipName = this.namingConvention.uniqueNameForGroup(subnetName);
        final String nicName = this.namingConvention.uniqueNameForGroup(subnetName);
        IpConfiguration config = IpConfiguration.builder().name(ipName).properties(ipProperties.build()).build();
        NetworkInterfaceCardProperties.Builder nicProperties = NetworkInterfaceCardProperties.builder().ipConfigurations((List<IpConfiguration>)ImmutableList.of((Object)config));
        if (securityGroup != null) {
            nicProperties.networkSecurityGroup(IdReference.create(securityGroup));
        }
        this.logger.debug(">> creating nic %s(%s) with security groups (%s)", new Object[]{nicName, config, securityGroup != null ? securityGroup : ""});
        final NetworkInterfaceCardApi nicApi = this.api.getNetworkInterfaceCardApi(resourceGroup);
        NetworkInterfaceCard nic = nicApi.createOrUpdate(nicName, location, nicProperties.build(), (Map<String, String>)ImmutableMap.of((Object)"jclouds", (Object)nodeName));
        this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

            public Provisionable get() {
                NetworkInterfaceCard updated = nicApi.get(nicName);
                return updated == null ? null : updated.properties();
            }
        });
        return nic;
    }

    private void configurePublicIP(IpOptions ipConfig, IpConfigurationProperties.Builder ipProperties, String resourceGroup, String location, String nodeName) {
        if (ipConfig.publicIpId() != null) {
            this.logger.debug(">> configuring public ip: %s", new Object[]{IdReference.extractName(ipConfig.publicIpId())});
            PublicIPAddress publicIp = this.api.getPublicIPAddressApi(IdReference.extractResourceGroup(ipConfig.publicIpId())).get(IdReference.extractName(ipConfig.publicIpId()));
            ipProperties.publicIPAddress(IdReference.create(publicIp.id()));
        } else if (ipConfig.allocateNewPublicIp()) {
            PublicIPAddress publicIp = this.createPublicIp(resourceGroup, location, nodeName);
            ipProperties.publicIPAddress(IdReference.create(publicIp.id()));
        }
    }

    private NetworkProfile createNetworkProfile(List<NetworkInterfaceCard> nics) {
        ArrayList<NetworkProfile.NetworkInterface> nicAttachments = new ArrayList<NetworkProfile.NetworkInterface>(nics.size());
        for (int i = 0; i < nics.size(); ++i) {
            nicAttachments.add(NetworkProfile.NetworkInterface.create(nics.get(i).id(), NetworkProfile.NetworkInterface.NetworkInterfaceProperties.create(i == 0)));
        }
        return NetworkProfile.create(nicAttachments);
    }

    private static List<IpOptions> publicIpsFirst(List<IpOptions> ipOptions) {
        ArrayList<IpOptions> sorted = new ArrayList<IpOptions>(ipOptions);
        Collections.sort(sorted, new Comparator<IpOptions>(){

            @Override
            public int compare(IpOptions o1, IpOptions o2) {
                return o1.allocateNewPublicIp() == o2.allocateNewPublicIp() ? 0 : (o1.allocateNewPublicIp() ? -1 : 1);
            }
        });
        return sorted;
    }

    private PublicIPAddress createPublicIp(String resourceGroup, String location, String nodeName) {
        String name = this.namingConvention.uniqueNameForGroup(nodeName);
        PublicIPAddressProperties properties = PublicIPAddressProperties.builder().publicIPAllocationMethod("Static").idleTimeoutInMinutes(4).build();
        this.logger.debug(">> allocating new public ip address: %s", new Object[]{name});
        PublicIPAddress ip = this.api.getPublicIPAddressApi(resourceGroup).createOrUpdate(name, location, (Map<String, String>)ImmutableMap.of((Object)"jclouds", (Object)nodeName, (Object)AUTOGENERATED_IP_KEY, (Object)"true"), properties);
        Preconditions.checkState((boolean)this.publicIpAvailable.create(resourceGroup).apply((Object)name), (Object)"Public IP was not provisioned in the configured timeout");
        return ip;
    }

    private StorageProfile createStorageProfile(org.jclouds.compute.domain.Image image, List<DataDisk> dataDisks) {
        return StorageProfile.create(this.createImageReference(image), this.createOSDisk(image), dataDisks);
    }

    private ImageReference createImageReference(org.jclouds.compute.domain.Image image) {
        return VMImages.isCustom(image.getId()) ? ImageReference.builder().customImageId(image.getProviderId()).build() : ImageReference.builder().publisher(image.getProviderId()).offer(image.getName()).sku(image.getVersion()).version("latest").build();
    }

    private OSDisk createOSDisk(org.jclouds.compute.domain.Image image) {
        OsFamily osFamily = image.getOperatingSystem().getFamily();
        String osType = osFamily == OsFamily.WINDOWS ? "Windows" : "Linux";
        return OSDisk.builder().osType(osType).caching(DataDisk.CachingTypes.READ_WRITE.toString()).createOption(CreationData.CreateOptions.FROM_IMAGE.toString()).managedDiskParameters(ManagedDiskParameters.create(null, StorageAccountType.STANDARD_LRS.toString())).build();
    }

    private IdReference getAvailabilitySetIdReference(AvailabilitySet availabilitySet) {
        return availabilitySet != null ? IdReference.create(availabilitySet.id()) : null;
    }
}

